/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.InputConstants;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.architectury.registry.client.particle.ParticleProviderRegistry;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.enums.MoveInputType;
import net.arna.jcraft.api.pose.PoseModifiers;
import net.arna.jcraft.api.registry.JParticleTypeRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.client.JClientConfig;
import net.arna.jcraft.client.gravity.util.GravityChannelClient;
import net.arna.jcraft.client.gui.hud.JCraftAbilityHud;
import net.arna.jcraft.client.net.ClientPacketHandler;
import net.arna.jcraft.client.particle.AuraArcParticle;
import net.arna.jcraft.client.particle.AuraBlobParticle;
import net.arna.jcraft.client.particle.BackstabParticle;
import net.arna.jcraft.client.particle.BitesTheDustParticle;
import net.arna.jcraft.client.particle.BlocksparkParticle;
import net.arna.jcraft.client.particle.BoomParticle;
import net.arna.jcraft.client.particle.ComboBreakerParticle;
import net.arna.jcraft.client.particle.CooldownCancelParticle;
import net.arna.jcraft.client.particle.DamageNumberParticle;
import net.arna.jcraft.client.particle.GoParticle;
import net.arna.jcraft.client.particle.HitsparkParticle;
import net.arna.jcraft.client.particle.InversionParticle;
import net.arna.jcraft.client.particle.InvertedHitsparkParticle;
import net.arna.jcraft.client.particle.KCParticle;
import net.arna.jcraft.client.particle.PixelParticle;
import net.arna.jcraft.client.particle.PurpleHazeCloudParticle;
import net.arna.jcraft.client.particle.PurpleHazeErraticParticle;
import net.arna.jcraft.client.particle.SpeedParticle;
import net.arna.jcraft.client.registry.JClientEventsRegistry;
import net.arna.jcraft.client.registry.JRenderLayerRegistry;
import net.arna.jcraft.client.renderer.effects.AttackHitboxEffectRenderer;
import net.arna.jcraft.client.renderer.effects.TimeErasePredictionEffectRenderer;
import net.arna.jcraft.client.rendering.DamageIndicatorManager;
import net.arna.jcraft.client.rendering.RenderHandler;
import net.arna.jcraft.client.rendering.StandUserPoseLoader;
import net.arna.jcraft.client.rendering.handler.CrimsonShaderHandler;
import net.arna.jcraft.client.rendering.handler.EpitaphVignetteShaderHandler;
import net.arna.jcraft.client.rendering.handler.InversionShaderHandler;
import net.arna.jcraft.client.rendering.handler.ZaWarudoShaderHandler;
import net.arna.jcraft.client.util.ClientEntityHandlerImpl;
import net.arna.jcraft.client.util.TrackedKeyBinding;
import net.arna.jcraft.common.util.MovementInputType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class JCraftClient {
    public static TrackedKeyBinding standSummon;
    public static TrackedKeyBinding heavyKey;
    public static TrackedKeyBinding barrageKey;
    public static TrackedKeyBinding ultKey;
    public static TrackedKeyBinding special1Key;
    public static TrackedKeyBinding special2Key;
    public static TrackedKeyBinding special3Key;
    public static TrackedKeyBinding comboBreaker;
    public static TrackedKeyBinding cooldownCancel;
    public static TrackedKeyBinding utility;
    public static TrackedKeyBinding dash;
    private static final AtomicReference<Object> bindings;
    private static final AtomicReference<Object> movementBindings;
    private static final AtomicReference<Object> trackedUseKey;
    public static Supplier<DecimalFormat> decimalFormat;
    public static boolean comboStarted;
    public static int framesSinceComboStarted;
    public static final List<String> comboRemarks;
    public static int comboCounter;
    public static float damageScaling;
    public static int framesSinceCounted;
    public static int IPSTriggerFramesLeft;
    public static final int IPS_TRIGGER_FRAMES = 120;

    public static void init() {
        JCraft.setClientEntityHandler(ClientEntityHandlerImpl.INSTANCE);
        AutoConfig.register(JClientConfig.class, JanksonConfigSerializer::new);
        JClientConfig.load();
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)new DecimalFormatUpdater());
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, StandUserPoseLoader::onReload);
        GravityChannelClient.init();
        JRenderLayerRegistry.init();
        RenderHandler.init();
        JClientEventsRegistry.registerClientEvents();
        JCraftAbilityHud.init();
        PoseModifiers.register();
        InversionShaderHandler.INSTANCE.init();
        ZaWarudoShaderHandler.INSTANCE.init();
        CrimsonShaderHandler.INSTANCE.init();
        EpitaphVignetteShaderHandler.INSTANCE.init();
        ClientPacketHandler.init();
        AttackHitboxEffectRenderer.init();
        TimeErasePredictionEffectRenderer.init();
    }

    public static void registerKeyBindings(@Nullable Consumer<KeyMapping> register) {
        if (register == null) {
            register = KeyMappingRegistry::register;
        }
        standSummon = TrackedKeyBinding.createAndRegister("key.jcraft.standsummon", InputConstants.Type.KEYSYM, 78, "key.category.jcraft", register);
        heavyKey = TrackedKeyBinding.createAndRegister("key.jcraft.heavy", InputConstants.Type.KEYSYM, 82, "key.category.jcraft", register);
        barrageKey = TrackedKeyBinding.createAndRegister("key.jcraft.barrage", InputConstants.Type.KEYSYM, 66, "key.category.jcraft", register);
        ultKey = TrackedKeyBinding.createAndRegister("key.jcraft.ultimate", InputConstants.Type.KEYSYM, 72, "key.category.jcraft", register);
        special1Key = TrackedKeyBinding.createAndRegister("key.jcraft.special1", InputConstants.Type.KEYSYM, 86, "key.category.jcraft", register);
        special2Key = TrackedKeyBinding.createAndRegister("key.jcraft.special2", InputConstants.Type.KEYSYM, 71, "key.category.jcraft", register);
        special3Key = TrackedKeyBinding.createAndRegister("key.jcraft.special3", InputConstants.Type.KEYSYM, 77, "key.category.jcraft", register);
        cooldownCancel = TrackedKeyBinding.createAndRegister("key.jcraft.cooldowncancel", InputConstants.Type.KEYSYM, 346, "key.category.jcraft", register);
        utility = TrackedKeyBinding.createAndRegister("key.jcraft.utility", InputConstants.Type.MOUSE, 4, "key.category.jcraft", register);
        dash = TrackedKeyBinding.createAndRegister("key.jcraft.dash", InputConstants.Type.MOUSE, 3, "key.category.jcraft", register);
    }

    public static void markIPSTriggered() {
        IPSTriggerFramesLeft = 120;
    }

    public static void markComboStarted() {
        comboStarted = true;
        framesSinceComboStarted = 0;
    }

    private static Map<TrackedKeyBinding, MovementInputType> createMovementBindingsMap() {
        Options options = Minecraft.m_91087_().f_91066_;
        return ImmutableMap.builder().put((Object)TrackedKeyBinding.wrap(options.f_92085_), (Object)MovementInputType.FORWARD).put((Object)TrackedKeyBinding.wrap(options.f_92087_), (Object)MovementInputType.BACKWARD).put((Object)TrackedKeyBinding.wrap(options.f_92086_), (Object)MovementInputType.LEFT).put((Object)TrackedKeyBinding.wrap(options.f_92088_), (Object)MovementInputType.RIGHT).put((Object)TrackedKeyBinding.wrap(options.f_92089_), (Object)MovementInputType.JUMP).put((Object)TrackedKeyBinding.wrap(options.f_92090_), (Object)MovementInputType.CROUCH).put((Object)dash, (Object)MovementInputType.DASH).build();
    }

    public static String generateName(KeyMapping keyBinding, boolean makeShort) {
        String str = keyBinding.m_90865_();
        String[] components = str.split("\\.");
        String last = components[components.length - 1];
        Object secondLast = components[components.length - 2] + " ";
        if (components[components.length - 2].equals("keyboard")) {
            secondLast = "";
        }
        if (makeShort) {
            if (((String)secondLast).length() > 0) {
                secondLast = ((String)secondLast).substring(0, 1);
            }
            if (last.length() > 0) {
                last = last.substring(0, 1);
            }
        }
        return StringUtils.capitalize((String)secondLast) + StringUtils.capitalize((String)last);
    }

    public static <E extends Enum<E>> Object2BooleanMap<E> getChangedInputs(Map<TrackedKeyBinding, E> bindings) {
        return (Object2BooleanMap)bindings.entrySet().stream().filter(entry -> ((TrackedKeyBinding)entry.getKey()).isChangedThisTick()).collect(Object2BooleanOpenHashMap::new, (map, entry) -> map.put((Object)((Enum)entry.getValue()), ((TrackedKeyBinding)entry.getKey()).isPressedThisTick()), Map::putAll);
    }

    @Nullable
    public static StandEntity<?, ?> getStandEntity() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return null;
        }
        for (Entity e : player.m_20197_()) {
            if (!(e instanceof StandEntity)) continue;
            StandEntity s = (StandEntity)e;
            return s;
        }
        return null;
    }

    private static DecimalFormat createDecimalFormat() {
        return new DecimalFormat("#.#", DecimalFormatSymbols.getInstance(Locale.forLanguageTag(Minecraft.m_91087_().f_91066_.f_92075_)));
    }

    public static void registerParticleSpriteSets() {
        ParticleProviderRegistry.register(JParticleTypeRegistry.COMBO_BREAK, ComboBreakerParticle.Factory::new);
        ParticleProviderRegistry.register(JParticleTypeRegistry.COOLDOWN_CANCEL, CooldownCancelParticle.Factory::new);
        ParticleProviderRegistry.register(JParticleTypeRegistry.HITSPARK_1, provider -> new HitsparkParticle.Factory((SpriteSet)provider, 0.4f, 5));
        ParticleProviderRegistry.register(JParticleTypeRegistry.HITSPARK_2, provider -> new HitsparkParticle.Factory((SpriteSet)provider, 0.66f, 6));
        ParticleProviderRegistry.register(JParticleTypeRegistry.HITSPARK_3, provider -> new HitsparkParticle.Factory((SpriteSet)provider, 1.0f, 8));
        ParticleProviderRegistry.register(JParticleTypeRegistry.INVERTED_HITSPARK_3, provider -> new InvertedHitsparkParticle.Factory((SpriteSet)provider, 1.0f, 8));
        ParticleProviderRegistry.register(JParticleTypeRegistry.STUN_SLASH, provider -> new HitsparkParticle.Factory((SpriteSet)provider, 0.6f, 6));
        ParticleProviderRegistry.register(JParticleTypeRegistry.STUN_PIERCE, provider -> new HitsparkParticle.Factory((SpriteSet)provider, 0.6f, 6));
        ParticleProviderRegistry.register(JParticleTypeRegistry.KCPARTICLE, KCParticle.Factory::new);
        ParticleProviderRegistry.register(JParticleTypeRegistry.BACKSTAB, BackstabParticle.Factory::new);
        ParticleProviderRegistry.register(JParticleTypeRegistry.SPEED_PARTICLE, SpeedParticle.Factory::new);
        ParticleProviderRegistry.register(JParticleTypeRegistry.BITES_THE_DUST, BitesTheDustParticle.Factory::new);
        ParticleProviderRegistry.register(JParticleTypeRegistry.BOOM_1, BoomParticle.Factory::new);
        ParticleProviderRegistry.register(JParticleTypeRegistry.PIXEL, PixelParticle.Factory::new);
        ParticleProviderRegistry.register(JParticleTypeRegistry.BLOCKSPARK, provider -> new BlocksparkParticle.Factory((SpriteSet)provider, 0.15f));
        ParticleProviderRegistry.register(JParticleTypeRegistry.GO, GoParticle.Factory::new);
        ParticleProviderRegistry.register(JParticleTypeRegistry.AURA_ARC, AuraArcParticle.Factory::new);
        ParticleProviderRegistry.register(JParticleTypeRegistry.AURA_BLOB, AuraBlobParticle.Factory::new);
        ParticleProviderRegistry.register(JParticleTypeRegistry.INVERSION, InversionParticle.Factory::new);
        ParticleProviderRegistry.register(JParticleTypeRegistry.SUN_LOCK_ON, BackstabParticle.Factory::new);
        ParticleProviderRegistry.register(JParticleTypeRegistry.PURPLE_HAZE_CLOUD, PurpleHazeCloudParticle.Factory::new);
        ParticleProviderRegistry.register(JParticleTypeRegistry.PURPLE_HAZE_PARTICLE, PurpleHazeErraticParticle.Factory::new);
        ParticleProviderRegistry.register(JParticleTypeRegistry.DAMAGE_NUMBER, DamageNumberParticle.Factory::new);
        DamageIndicatorManager.setDamageNumberParticle((SimpleParticleType)JParticleTypeRegistry.DAMAGE_NUMBER.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<TrackedKeyBinding, MoveInputType> getBindings() {
        Object $value = bindings.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = bindings;
            synchronized (atomicReference) {
                $value = bindings.get();
                if ($value == null) {
                    ImmutableMap actualValue = ImmutableMap.builder().put((Object)standSummon, (Object)MoveInputType.STAND_SUMMON).put((Object)TrackedKeyBinding.wrap(Minecraft.m_91087_().f_91066_.f_92096_), (Object)MoveInputType.LIGHT).put((Object)heavyKey, (Object)MoveInputType.HEAVY).put((Object)barrageKey, (Object)MoveInputType.BARRAGE).put((Object)special1Key, (Object)MoveInputType.SPECIAL1).put((Object)special2Key, (Object)MoveInputType.SPECIAL2).put((Object)special3Key, (Object)MoveInputType.SPECIAL3).put((Object)ultKey, (Object)MoveInputType.ULTIMATE).put((Object)utility, (Object)MoveInputType.UTILITY).build();
                    $value = actualValue == null ? bindings : actualValue;
                    bindings.set($value);
                }
            }
        }
        return (Map)($value == bindings ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<TrackedKeyBinding, MovementInputType> getMovementBindings() {
        Object $value = movementBindings.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = movementBindings;
            synchronized (atomicReference) {
                $value = movementBindings.get();
                if ($value == null) {
                    Map<TrackedKeyBinding, MovementInputType> actualValue = JCraftClient.createMovementBindingsMap();
                    $value = actualValue == null ? movementBindings : actualValue;
                    movementBindings.set($value);
                }
            }
        }
        return (Map)($value == movementBindings ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TrackedKeyBinding getTrackedUseKey() {
        Object $value = trackedUseKey.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = trackedUseKey;
            synchronized (atomicReference) {
                $value = trackedUseKey.get();
                if ($value == null) {
                    TrackedKeyBinding actualValue = TrackedKeyBinding.wrap(Minecraft.m_91087_().f_91066_.f_92095_);
                    $value = actualValue == null ? trackedUseKey : actualValue;
                    trackedUseKey.set($value);
                }
            }
        }
        return (TrackedKeyBinding)($value == trackedUseKey ? null : $value);
    }

    static {
        bindings = new AtomicReference();
        movementBindings = new AtomicReference();
        trackedUseKey = new AtomicReference();
        decimalFormat = Suppliers.memoize(JCraftClient::createDecimalFormat);
        comboStarted = false;
        framesSinceComboStarted = 0;
        comboRemarks = List.of("admin rdm!!!", "baby combo", "caught lackin", "kinda ez", "skill issue", "cancelled on twitter", "sent to bulgaria", "down bad");
        comboCounter = 0;
        damageScaling = 1.0f;
        framesSinceCounted = 0;
        IPSTriggerFramesLeft = 0;
    }

    private static class DecimalFormatUpdater
    implements PreparableReloadListener {
        private final ResourceLocation fabricId = JCraft.id("decimal_format_updater");

        private DecimalFormatUpdater() {
        }

        public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier synchronizer, ResourceManager manager, ProfilerFiller prepareProfiler, ProfilerFiller applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
            return synchronizer.m_6769_((Object)Unit.INSTANCE).thenRunAsync(() -> {
                decimalFormat = Suppliers.memoize(JCraftClient::createDecimalFormat);
            }, applyExecutor);
        }

        public ResourceLocation getFabricId() {
            return this.fabricId;
        }
    }
}

