/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.argumenttype;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.arna.jcraft.api.pose.ModifierCondition;
import net.arna.jcraft.api.pose.PoseModifiers;
import net.arna.jcraft.api.pose.modifier.IPoseModifier;

public class PoseModifierArgument
implements ArgumentType<ParsedPose> {
    private static final SimpleCommandExceptionType INVALID_POSE_MODIFIER = new SimpleCommandExceptionType(() -> "Invalid pose modifier");

    public ParsedPose parse(StringReader reader) throws CommandSyntaxException {
        String input = reader.getRemaining();
        int c = reader.getCursor();
        reader.setCursor(c + input.length());
        try {
            return new ParsedPose(input, PoseModifiers.parse(input, new ModifierCondition[0]));
        }
        catch (IllegalArgumentException e) {
            reader.setCursor(c);
            throw INVALID_POSE_MODIFIER.createWithContext((ImmutableStringReader)reader);
        }
    }

    private PoseModifierArgument() {
    }

    public static PoseModifierArgument pose() {
        return new PoseModifierArgument();
    }

    public record ParsedPose(String raw, IPoseModifier pose) {
    }
}

