/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.architectury.event.events.client.ClientCommandRegistrationEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.List;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.pose.ModelType;
import net.arna.jcraft.api.pose.PoseModifiers;
import net.arna.jcraft.api.pose.modifier.IPoseModifier;
import net.arna.jcraft.api.pose.modifier.PoseModifierGroup;
import net.arna.jcraft.client.argumenttype.ModelTypeArgument;
import net.arna.jcraft.client.argumenttype.PoseModifierArgument;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public class JPoseCommand {
    private static final List<PoseModifierArgument.ParsedPose> POSES = new ArrayList<PoseModifierArgument.ParsedPose>();
    private static IPoseModifier builtPose = IPoseModifier.EMPTY;
    private static ModelType<?> currentType = ModelType.HUMANOID;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void register(CommandDispatcher<ClientCommandRegistrationEvent.ClientCommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)JPoseCommand.literal("jpose").then(JPoseCommand.literal("help").executes(JPoseCommand::runHelp))).then(JPoseCommand.literal("add").then(JPoseCommand.argument("pose", PoseModifierArgument.pose()).executes(JPoseCommand::runAdd)))).then(JPoseCommand.literal("insert").then(JPoseCommand.argument("index", IntegerArgumentType.integer((int)1)).executes(JPoseCommand::runInsert)))).then(JPoseCommand.literal("remove").then(JPoseCommand.argument("index", IntegerArgumentType.integer((int)1)).executes(JPoseCommand::runRemove)))).then(JPoseCommand.literal("replace").then(JPoseCommand.argument("pose", PoseModifierArgument.pose()).executes(JPoseCommand::runReplace)))).then(JPoseCommand.literal("list").executes(JPoseCommand::runList))).then(((LiteralArgumentBuilder)JPoseCommand.literal("model").then(JPoseCommand.literal("set").then(JPoseCommand.argument("model", ModelTypeArgument.modelType()).executes(JPoseCommand::runSetModel)))).then(JPoseCommand.literal("get").executes(JPoseCommand::runGetModel)))).then(JPoseCommand.literal("clear").executes(JPoseCommand::runClear))).then(((LiteralArgumentBuilder)JPoseCommand.literal("export").then(JPoseCommand.literal("raw").executes(ctx -> JPoseCommand.runExport((CommandContext<ClientCommandRegistrationEvent.ClientCommandSourceStack>)ctx, true)))).then(JPoseCommand.literal("json").executes(ctx -> JPoseCommand.runExport((CommandContext<ClientCommandRegistrationEvent.ClientCommandSourceStack>)ctx, false)))));
    }

    private static int runHelp(CommandContext<ClientCommandRegistrationEvent.ClientCommandSourceStack> ctx) {
        String help = "/jpose: an in-game pose designer for JCraft.\nDefinitions:\n- Pose: A set of transformations applied to a model.\n  A pose consists of the following components:\n  - A model part (usually \"head\", \"leftArm\", \"rightLeg\", etc.)\n  - A property (x, y, z, xRot, yRot, zRot, xScale, yScale, zScale)\n  - An operator (one of =, +=, -=, *=, /=)\n    = sets the property to a constant value while the others modify the current value.\n  - A value (a (floating-point) number, optionally followed by \"deg\" for degrees)\n    Make sure to add \"deg\" when adding degrees to rotation properties as rotations are in radians by default.\n  - Optionally a comment ('//' followed by any text)\n\n  Examples:\n  - leftArm.zRot += 110deg // Adds 110 degrees to the z rotation of the left arm.\n  - rightLeg.xScale = 1.5\n  - leftLeg.x = 5 // dismembered leg\n- Model type: the type of model the pose will be applied to.\n  'humanoid' by default, this is currently also the only supported type.\n\nCommands:\n- /jpose add <pose>: Adds a pose modifier to the end of the list.\n- /jpose insert <index> <pose>: Inserts a pose modifier at the specified index.\n- /jpose remove <index>: Removes the pose modifier at the specified index.\n- /jpose replace <pose>: Replaces the last pose modifier with the new one.\n- /jpose list: Lists all current pose modifiers.\n- /jpose model set <model>: Sets the current model type for the pose modifiers.\n  All entities using this model type will be affected by the pose modifiers.\n- /jpose model get: Gets the current model type.\n- /jpose clear: Clears all pose modifiers.\n- /jpose export raw: Exports the current pose modifiers as raw code to the clipboard.\n- /jpose export json: Exports the current pose modifiers as a JSON asset to the clipboard.\n";
        ((ClientCommandRegistrationEvent.ClientCommandSourceStack)ctx.getSource()).arch$sendSuccess(() -> Component.m_237113_((String)"/jpose: an in-game pose designer for JCraft.\nDefinitions:\n- Pose: A set of transformations applied to a model.\n  A pose consists of the following components:\n  - A model part (usually \"head\", \"leftArm\", \"rightLeg\", etc.)\n  - A property (x, y, z, xRot, yRot, zRot, xScale, yScale, zScale)\n  - An operator (one of =, +=, -=, *=, /=)\n    = sets the property to a constant value while the others modify the current value.\n  - A value (a (floating-point) number, optionally followed by \"deg\" for degrees)\n    Make sure to add \"deg\" when adding degrees to rotation properties as rotations are in radians by default.\n  - Optionally a comment ('//' followed by any text)\n\n  Examples:\n  - leftArm.zRot += 110deg // Adds 110 degrees to the z rotation of the left arm.\n  - rightLeg.xScale = 1.5\n  - leftLeg.x = 5 // dismembered leg\n- Model type: the type of model the pose will be applied to.\n  'humanoid' by default, this is currently also the only supported type.\n\nCommands:\n- /jpose add <pose>: Adds a pose modifier to the end of the list.\n- /jpose insert <index> <pose>: Inserts a pose modifier at the specified index.\n- /jpose remove <index>: Removes the pose modifier at the specified index.\n- /jpose replace <pose>: Replaces the last pose modifier with the new one.\n- /jpose list: Lists all current pose modifiers.\n- /jpose model set <model>: Sets the current model type for the pose modifiers.\n  All entities using this model type will be affected by the pose modifiers.\n- /jpose model get: Gets the current model type.\n- /jpose clear: Clears all pose modifiers.\n- /jpose export raw: Exports the current pose modifiers as raw code to the clipboard.\n- /jpose export json: Exports the current pose modifiers as a JSON asset to the clipboard.\n"), false);
        return 1;
    }

    private static int runAdd(CommandContext<ClientCommandRegistrationEvent.ClientCommandSourceStack> ctx) {
        if (JPoseCommand.checkNotSingleplayer((ClientCommandRegistrationEvent.ClientCommandSourceStack)ctx.getSource())) {
            return 0;
        }
        ClientCommandRegistrationEvent.ClientCommandSourceStack source = (ClientCommandRegistrationEvent.ClientCommandSourceStack)ctx.getSource();
        PoseModifierArgument.ParsedPose pose = (PoseModifierArgument.ParsedPose)ctx.getArgument("pose", PoseModifierArgument.ParsedPose.class);
        return JPoseCommand.tryInsert(source, pose, POSES.size());
    }

    private static int runInsert(CommandContext<ClientCommandRegistrationEvent.ClientCommandSourceStack> ctx) {
        if (JPoseCommand.checkNotSingleplayer((ClientCommandRegistrationEvent.ClientCommandSourceStack)ctx.getSource())) {
            return 0;
        }
        ClientCommandRegistrationEvent.ClientCommandSourceStack source = (ClientCommandRegistrationEvent.ClientCommandSourceStack)ctx.getSource();
        PoseModifierArgument.ParsedPose pose = (PoseModifierArgument.ParsedPose)ctx.getArgument("pose", PoseModifierArgument.ParsedPose.class);
        int index = (Integer)ctx.getArgument("index", Integer.class) - 1;
        if (index < 0 || index > POSES.size()) {
            source.arch$sendFailure((Component)Component.m_237113_((String)("Index out of bounds: " + index)).m_130940_(ChatFormatting.RED));
            return 0;
        }
        return JPoseCommand.tryInsert(source, pose, index);
    }

    private static int tryInsert(ClientCommandRegistrationEvent.ClientCommandSourceStack source, PoseModifierArgument.ParsedPose pose, int index) {
        if (currentType == null) {
            source.arch$sendFailure((Component)Component.m_237113_((String)"No model type set. Use '/jpose model set <model>' to set one.").m_130940_(ChatFormatting.RED));
            return 0;
        }
        if (!pose.pose().isModelSupported(currentType)) {
            source.arch$sendFailure((Component)Component.m_237113_((String)("Pose modifier is not compatible with the current model type: " + currentType.getName())).m_130940_(ChatFormatting.RED));
            return 0;
        }
        POSES.add(index, pose);
        JPoseCommand.rebuildModifier();
        source.arch$sendSuccess(() -> Component.m_237113_((String)("Pose modifier added: " + pose.raw())), false);
        return 1;
    }

    private static int runRemove(CommandContext<ClientCommandRegistrationEvent.ClientCommandSourceStack> ctx) {
        if (JPoseCommand.checkNotSingleplayer((ClientCommandRegistrationEvent.ClientCommandSourceStack)ctx.getSource())) {
            return 0;
        }
        ClientCommandRegistrationEvent.ClientCommandSourceStack source = (ClientCommandRegistrationEvent.ClientCommandSourceStack)ctx.getSource();
        int index = (Integer)ctx.getArgument("index", Integer.class) - 1;
        if (index < 0 || index >= POSES.size()) {
            source.arch$sendFailure((Component)Component.m_237113_((String)("Index out of bounds: " + index)).m_130940_(ChatFormatting.RED));
            return 0;
        }
        PoseModifierArgument.ParsedPose removedPose = POSES.remove(index);
        JPoseCommand.rebuildModifier();
        source.arch$sendSuccess(() -> Component.m_237113_((String)("Pose modifier removed: " + removedPose.raw())), false);
        return 1;
    }

    private static int runReplace(CommandContext<ClientCommandRegistrationEvent.ClientCommandSourceStack> ctx) {
        PoseModifierArgument.ParsedPose pose;
        if (JPoseCommand.checkNotSingleplayer((ClientCommandRegistrationEvent.ClientCommandSourceStack)ctx.getSource())) {
            return 0;
        }
        ClientCommandRegistrationEvent.ClientCommandSourceStack source = (ClientCommandRegistrationEvent.ClientCommandSourceStack)ctx.getSource();
        int res = JPoseCommand.tryInsert(source, pose = (PoseModifierArgument.ParsedPose)ctx.getArgument("pose", PoseModifierArgument.ParsedPose.class), POSES.size());
        if (res == 0) {
            return 0;
        }
        PoseModifierArgument.ParsedPose removed = null;
        int index = POSES.size() - 2;
        if (index >= 0) {
            removed = POSES.remove(index);
        }
        JPoseCommand.rebuildModifier();
        MutableComponent msg = Component.m_237113_((String)(removed == null ? "Pose modifier added: " + pose.raw() : "Replaced pose modifier '" + removed.raw() + "' with '" + pose.raw() + "'."));
        source.arch$sendSuccess(() -> JPoseCommand.lambda$runReplace$6((Component)msg), false);
        return 1;
    }

    private static int runList(CommandContext<ClientCommandRegistrationEvent.ClientCommandSourceStack> ctx) {
        if (JPoseCommand.checkNotSingleplayer((ClientCommandRegistrationEvent.ClientCommandSourceStack)ctx.getSource())) {
            return 0;
        }
        ClientCommandRegistrationEvent.ClientCommandSourceStack source = (ClientCommandRegistrationEvent.ClientCommandSourceStack)ctx.getSource();
        if (POSES.isEmpty()) {
            source.arch$sendFailure((Component)Component.m_237113_((String)"No pose modifiers set."));
            return 0;
        }
        MutableComponent comp = Component.m_237119_().m_130946_("Current pose modifiers:");
        for (int i = 0; i < POSES.size(); ++i) {
            PoseModifierArgument.ParsedPose pose = POSES.get(i);
            comp.m_7220_((Component)Component.m_237119_().m_130946_("\n").m_130946_(i + 1 + ". ").m_7220_((Component)Component.m_237113_((String)pose.raw()).m_130948_(pose.pose().isModelSupported(currentType) ? Style.f_131099_ : Style.f_131099_.m_131140_(ChatFormatting.RED))));
        }
        source.arch$sendSuccess(() -> comp, false);
        return 1;
    }

    private static int runSetModel(CommandContext<ClientCommandRegistrationEvent.ClientCommandSourceStack> ctx) {
        ModelType type;
        if (JPoseCommand.checkNotSingleplayer((ClientCommandRegistrationEvent.ClientCommandSourceStack)ctx.getSource())) {
            return 0;
        }
        ClientCommandRegistrationEvent.ClientCommandSourceStack source = (ClientCommandRegistrationEvent.ClientCommandSourceStack)ctx.getSource();
        currentType = type = (ModelType)ctx.getArgument("model", ModelType.class);
        JPoseCommand.rebuildModifier();
        if (!POSES.stream().allMatch(pose -> pose.pose().isModelSupported(currentType))) {
            source.arch$sendFailure((Component)Component.m_237113_((String)"Some pose modifiers are not compatible with the selected model type. Check the problematic poses with '/jpose list'.").m_130940_(ChatFormatting.RED));
        }
        source.arch$sendSuccess(() -> Component.m_237113_((String)("Model type set to " + type.getName())), false);
        return 1;
    }

    private static int runGetModel(CommandContext<ClientCommandRegistrationEvent.ClientCommandSourceStack> ctx) {
        if (JPoseCommand.checkNotSingleplayer((ClientCommandRegistrationEvent.ClientCommandSourceStack)ctx.getSource())) {
            return 0;
        }
        ClientCommandRegistrationEvent.ClientCommandSourceStack source = (ClientCommandRegistrationEvent.ClientCommandSourceStack)ctx.getSource();
        if (currentType == null) {
            source.arch$sendFailure((Component)Component.m_237113_((String)"No model type set."));
            return 0;
        }
        source.arch$sendSuccess(() -> Component.m_237113_((String)("Current model type: " + currentType.getName())), false);
        return 1;
    }

    private static int runClear(CommandContext<ClientCommandRegistrationEvent.ClientCommandSourceStack> ctx) {
        if (JPoseCommand.checkNotSingleplayer((ClientCommandRegistrationEvent.ClientCommandSourceStack)ctx.getSource())) {
            return 0;
        }
        ClientCommandRegistrationEvent.ClientCommandSourceStack source = (ClientCommandRegistrationEvent.ClientCommandSourceStack)ctx.getSource();
        if (POSES.isEmpty()) {
            source.arch$sendFailure((Component)Component.m_237113_((String)"No pose modifier set."));
            return 0;
        }
        builtPose = IPoseModifier.EMPTY;
        POSES.clear();
        source.arch$sendSuccess(() -> Component.m_237113_((String)"Pose modifier reset."), false);
        return 1;
    }

    private static int runExport(CommandContext<ClientCommandRegistrationEvent.ClientCommandSourceStack> ctx, boolean raw) {
        String output;
        if (JPoseCommand.checkNotSingleplayer((ClientCommandRegistrationEvent.ClientCommandSourceStack)ctx.getSource())) {
            return 0;
        }
        ClientCommandRegistrationEvent.ClientCommandSourceStack source = (ClientCommandRegistrationEvent.ClientCommandSourceStack)ctx.getSource();
        if (POSES.isEmpty()) {
            source.arch$sendFailure((Component)Component.m_237113_((String)"No pose modifier set."));
            return 0;
        }
        if (raw) {
            output = POSES.stream().map(PoseModifierArgument.ParsedPose::raw).reduce("", (a, b) -> a + ";\n" + b).substring(2);
        } else {
            DataResult res = PoseModifiers.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)builtPose);
            if (res.error().isPresent()) {
                source.arch$sendFailure((Component)Component.m_237113_((String)("Failed to export pose modifier: " + ((DataResult.PartialResult)res.error().get()).message())).m_130940_(ChatFormatting.RED));
                return 0;
            }
            JsonElement json = (JsonElement)res.result().orElseThrow();
            output = GSON.toJson(json);
        }
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(output), null);
        }
        catch (Exception e) {
            JCraft.LOGGER.error("Failed to copy pose modifier to clipboard", (Throwable)e);
            source.arch$sendFailure((Component)Component.m_237113_((String)("Failed to copy pose modifier to clipboard: " + e.getMessage())).m_130940_(ChatFormatting.RED));
            return 0;
        }
        source.arch$sendSuccess(() -> Component.m_237113_((String)"Pose modifier code has been copied to your clipboard."), false);
        return 1;
    }

    public static boolean hasPose(ModelType<?> type) {
        return type == currentType && !POSES.isEmpty();
    }

    public static IPoseModifier getPose() {
        return builtPose;
    }

    private static void rebuildModifier() {
        if (currentType == null) {
            builtPose = IPoseModifier.EMPTY;
            return;
        }
        List<IPoseModifier> filteredMods = POSES.stream().map(PoseModifierArgument.ParsedPose::pose).filter(pose -> pose.isModelSupported(currentType)).toList();
        builtPose = PoseModifierGroup.builder().modifiers(filteredMods).build();
    }

    private static boolean checkNotSingleplayer(ClientCommandRegistrationEvent.ClientCommandSourceStack source) {
        if (!Minecraft.m_91087_().m_257720_()) {
            source.arch$sendFailure((Component)Component.m_237113_((String)"This command can only be used in singleplayer.").m_130940_(ChatFormatting.RED));
            return true;
        }
        return false;
    }

    @NotNull
    private static LiteralArgumentBuilder<ClientCommandRegistrationEvent.ClientCommandSourceStack> literal(String literal) {
        return LiteralArgumentBuilder.literal((String)literal);
    }

    @NotNull
    private static <T> RequiredArgumentBuilder<ClientCommandRegistrationEvent.ClientCommandSourceStack, T> argument(String name, ArgumentType<T> argumentType) {
        return RequiredArgumentBuilder.argument((String)name, argumentType);
    }

    private static /* synthetic */ Component lambda$runReplace$6(Component msg) {
        return msg;
    }

    static {
        ClientLifecycleEvent.CLIENT_LEVEL_LOAD.register(level -> {
            POSES.clear();
            builtPose = IPoseModifier.EMPTY;
        });
    }
}

