/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Iterator;
import java.util.List;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.enums.MoveInputType;
import net.arna.jcraft.api.component.living.CommonCooldownsComponent;
import net.arna.jcraft.api.registry.JPacketRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.client.JClientConfig;
import net.arna.jcraft.client.JCraftClient;
import net.arna.jcraft.client.gui.hud.JCraftAbilityHud;
import net.arna.jcraft.client.rendering.RenderHandler;
import net.arna.jcraft.client.util.JClientUtils;
import net.arna.jcraft.client.util.TrackedKeyBinding;
import net.arna.jcraft.common.network.c2s.PlayerInputPacket;
import net.arna.jcraft.common.network.c2s.StandBlockPacket;
import net.arna.jcraft.common.tickable.Timestops;
import net.arna.jcraft.common.util.ColorUtils;
import net.arna.jcraft.common.util.CooldownType;
import net.arna.jcraft.common.util.DimensionData;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.common.util.MovementInputType;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@OnlyIn(value=Dist.CLIENT)
public class JClientEvents {
    public static void onLast(PoseStack matrixStack, Vec3 cameraPos) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        Minecraft.m_91087_().m_91385_().m_83947_(false);
        RenderHandler.beginBufferedRendering(matrixStack);
        if (RenderHandler.MATRIX4F != null) {
            RenderSystem.getModelViewMatrix().get(RenderHandler.MATRIX4F);
        }
        RenderHandler.renderBufferedBatches(matrixStack);
        RenderHandler.endBufferedRendering(matrixStack);
        matrixStack.m_85849_();
    }

    public static void afterTranslucent(PoseStack matrixStack, Vec3 cameraPos, LevelRenderer worldRenderer) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        RenderHandler.MATRIX4F = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
        matrixStack.m_85849_();
    }

    public static void clientPlayerJoin(LocalPlayer clientPlayerEntity) {
        if (clientPlayerEntity == null) {
            JCraft.LOGGER.fatal("onPlayReady was called with invalid client player!");
            return;
        }
    }

    public static void renderHud(GuiGraphics ctx, float tickDelta) {
        Minecraft client = Minecraft.m_91087_();
        LocalPlayer player = client.f_91074_;
        if (player == null) {
            JCraft.LOGGER.fatal("Attempted to render hud with no player!");
            return;
        }
        ++JCraftClient.framesSinceCounted;
        JClientConfig config = JClientConfig.getInstance();
        boolean isMid = config.getUiPosition() == JClientConfig.UIPos.MIDDLE;
        boolean useIcons = config.isIconHud();
        StandEntity<?, ?> stand = JUtils.getStand((LivingEntity)player);
        Font textRenderer = client.f_91065_.m_93082_();
        int selectedX = JCraftAbilityHud.getHudX(client.m_91268_().m_85445_(), 128) + config.getHorizontalHudOffset();
        int selectedY = client.m_91268_().m_85446_() + config.getVerticalHudOffset();
        switch (config.getUiPosition()) {
            case LEFT: {
                selectedY /= 20;
                break;
            }
            case MIDDLE: {
                selectedY /= 3;
                break;
            }
            case RIGHT: {
                selectedY = (int)((float)selectedY / 2.25f);
            }
        }
        if (!useIcons) {
            CommonCooldownsComponent cooldowns = JComponentPlatformUtils.getCooldowns((LivingEntity)player);
            CooldownType[] values = CooldownType.values();
            for (int i = 0; i < values.length; ++i) {
                CooldownType type = values[i];
                int cooldownTicks = cooldowns.getCooldown(type);
                if (cooldownTicks == 0) continue;
                double cooldown = (double)((float)cooldownTicks - tickDelta) / 20.0;
                String keyBindText = JCraftAbilityHud.cooldownTypeToKeybind(type, false);
                CooldownType.Category category = type.getCategory();
                boolean isSpec = category == CooldownType.Category.SPEC;
                boolean isUniversal = category == CooldownType.Category.UNIVERSAL;
                float defaultAlpha = 0.65f;
                int xOffset = 0;
                String finalText = keyBindText + " - " + JCraftClient.decimalFormat.get().format(Mth.m_14008_((double)cooldown, (double)0.0, (double)9999.0)) + "s";
                if (category == CooldownType.Category.STAND || isSpec) {
                    if (!isSpec) {
                        finalText = "s." + finalText;
                    }
                    if (isSpec && stand != null || !isSpec && stand == null) {
                        xOffset = 48;
                        defaultAlpha = 0.3f;
                    }
                }
                int offsetIndex = i;
                if (isSpec) {
                    offsetIndex -= 7;
                } else if (isUniversal) {
                    offsetIndex -= 6;
                }
                float offsetY = (float)selectedY * 1.25f + 9.0f * (float)offsetIndex;
                ctx.m_280488_(textRenderer, finalText, selectedX + xOffset, (int)offsetY, ColorUtils.HSBAtoRGBA(0.3f - (float)cooldown * 10.0f / 720.0f, cooldown < 1.6 ? 0.0f : 1.0f, 1.0f, cooldown < 1.6 ? 1.0f : defaultAlpha));
            }
        }
        if (JCraftClient.comboCounter > 0 && JClientConfig.getInstance().isComboCounter() && JCraftClient.framesSinceCounted <= 180) {
            boolean ipsTriggered;
            String remark = "epic tod free download";
            if (JCraftClient.comboCounter < JCraftClient.comboRemarks.size() * 7) {
                remark = JCraftClient.comboRemarks.get(Math.floorDiv(JCraftClient.comboCounter, 7));
            }
            boolean recentHit = JCraftClient.framesSinceCounted < 5;
            RandomSource random = player.m_217043_();
            if (JCraftClient.comboStarted && ++JCraftClient.framesSinceComboStarted > 59) {
                JCraftClient.comboStarted = false;
            }
            boolean bl = ipsTriggered = JCraftClient.IPSTriggerFramesLeft-- > 0;
            if (ipsTriggered) {
                selectedX = (int)((float)selectedX + random.m_188501_() * (float)JCraftClient.IPSTriggerFramesLeft / 20.0f);
                selectedY = (int)((float)selectedY + random.m_188501_() * (float)JCraftClient.IPSTriggerFramesLeft / 20.0f);
            }
            ctx.m_280488_(textRenderer, JCraftClient.comboCounter + " - (" + Math.round(JCraftClient.damageScaling * 100.0f) + "%) - " + remark, (int)((float)selectedX + (isMid && useIcons ? 54.0f : 0.0f) + (recentHit ? tickDelta * random.m_188501_() * 5.0f : 0.0f)), (int)((float)selectedY * 1.15f + (recentHit ? tickDelta * random.m_188501_() * 5.0f : 0.0f)), ipsTriggered ? ColorUtils.HSBAtoRGBA(0.5f, (float)(120 - JCraftClient.IPSTriggerFramesLeft) / 120.0f, 1.0f, 0.8f) : ColorUtils.HSBAtoRGBA((float)JCraftClient.comboCounter / 360.0f - 1.0f, JCraftClient.comboStarted ? (float)JCraftClient.framesSinceComboStarted / 60.0f : 1.0f, 1.0f, 0.8f));
        }
    }

    public static void tickClient(Minecraft client) {
        LocalPlayer player = client.f_91074_;
        if (player == null) {
            return;
        }
        StandEntity<?, ?> stand = JUtils.getStand((LivingEntity)player);
        if (player.m_6084_()) {
            Object2BooleanMap<MovementInputType> movementInput = JCraftClient.getChangedInputs(JCraftClient.getMovementBindings());
            Object2BooleanMap<MoveInputType> moveInput = JCraftClient.getChangedInputs(JCraftClient.getBindings());
            if (!movementInput.isEmpty() || !moveInput.isEmpty()) {
                NetworkManager.sendToServer((ResourceLocation)JPacketRegistry.C2S_PLAYER_INPUT, (FriendlyByteBuf)PlayerInputPacket.write(movementInput, moveInput));
            }
            Object2BooleanOpenHashMap heldMoves = new Object2BooleanOpenHashMap();
            JCraftClient.getBindings().forEach((arg_0, arg_1) -> JClientEvents.lambda$tickClient$0((Object2BooleanMap)heldMoves, arg_0, arg_1));
            if (!heldMoves.isEmpty()) {
                NetworkManager.sendToServer((ResourceLocation)JPacketRegistry.C2S_PLAYER_INPUT_HOLD, (FriendlyByteBuf)PlayerInputPacket.write(null, (Object2BooleanMap<MoveInputType>)heldMoves));
            }
        }
        if (JCraftClient.getTrackedUseKey().isChangedThisTick()) {
            boolean pressed = JCraftClient.getTrackedUseKey().isPressedThisTick();
            NetworkManager.sendToServer((ResourceLocation)JPacketRegistry.C2S_STAND_BLOCK, (FriendlyByteBuf)StandBlockPacket.write(pressed));
            if (stand != null && stand.isRemoteAndControllable() && pressed) {
                NetworkManager.sendToServer((ResourceLocation)JPacketRegistry.C2S_REMOTE_STAND_INTERACT, (FriendlyByteBuf)new FriendlyByteBuf(Unpooled.buffer()));
            }
        }
        if (JCraftClient.cooldownCancel.isPressedThisTick()) {
            NetworkManager.sendToServer((ResourceLocation)JPacketRegistry.C2S_COOLDOWN_CANCEL, (FriendlyByteBuf)new FriendlyByteBuf(Unpooled.buffer()));
        }
        if (client.m_91104_() && client.m_91090_()) {
            return;
        }
        Iterator<DimensionData> iter = JClientUtils.activeTimestops.iterator();
        while (iter.hasNext()) {
            DimensionData timestop = iter.next();
            LivingEntity user = timestop.getUser();
            if (user != null && user.m_6084_()) {
                timestop.decreaseTimer();
                if (timestop.getTimer() <= 0) {
                    iter.remove();
                    continue;
                }
            } else {
                iter.remove();
                continue;
            }
            Vec3 pos = timestop.getPos();
            List toStop = user.m_9236_().m_6443_(Entity.class, new AABB(pos.m_82520_(96.0, 96.0, 96.0), pos.m_82492_(96.0, 96.0, 96.0)), Timestops.TIMESTOP_PREDICATE);
            for (Entity entity : toStop) {
                if (entity == user || entity == JUtils.getStand(user) || entity == user.m_20202_()) continue;
                JComponentPlatformUtils.getTimeStopData(entity).ifPresent(d -> d.setTicks(2));
            }
        }
        TrackedKeyBinding.resetValues(client.f_91080_ != null);
    }

    private static /* synthetic */ void lambda$tickClient$0(Object2BooleanMap heldMoves, TrackedKeyBinding key, MoveInputType value) {
        if (key.isDown()) {
            heldMoves.put((Object)value, true);
        }
    }
}

