/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.gravity.util;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.function.Function;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.client.gravity.util.NetworkUtilClient;
import net.arna.jcraft.common.gravity.util.GravityVerifierRegistry;
import net.arna.jcraft.common.gravity.util.packet.DefaultGravityPacket;
import net.arna.jcraft.common.gravity.util.packet.GravityPacket;
import net.arna.jcraft.common.gravity.util.packet.InvertGravityPacket;
import net.arna.jcraft.common.gravity.util.packet.OverwriteGravityPacket;
import net.arna.jcraft.common.gravity.util.packet.UpdateGravityPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class GravityChannelClient<P extends GravityPacket> {
    public static GravityChannelClient<OverwriteGravityPacket> OVERWRITE_GRAVITY = new GravityChannelClient<OverwriteGravityPacket>(OverwriteGravityPacket::new, JCraft.id("g_overwrite_gravity_list"));
    public static GravityChannelClient<UpdateGravityPacket> UPDATE_GRAVITY = new GravityChannelClient<UpdateGravityPacket>(UpdateGravityPacket::new, JCraft.id("g_update_gravity_list"));
    public static GravityChannelClient<DefaultGravityPacket> DEFAULT_GRAVITY = new GravityChannelClient<DefaultGravityPacket>(DefaultGravityPacket::new, JCraft.id("g_default_gravity"));
    public static GravityChannelClient<InvertGravityPacket> INVERT_GRAVITY = new GravityChannelClient<InvertGravityPacket>(InvertGravityPacket::new, JCraft.id("g_inverted"));
    private final Function<FriendlyByteBuf, P> packetFactory;
    private final ResourceLocation channel;
    private final GravityVerifierRegistry<P> gravityVerifierRegistry;

    GravityChannelClient(Function<FriendlyByteBuf, P> _packetFactory, ResourceLocation _channel) {
        this.packetFactory = _packetFactory;
        this.channel = _channel;
        this.gravityVerifierRegistry = new GravityVerifierRegistry();
    }

    public void receiveFromServer(Minecraft client, FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        GravityPacket packet = (GravityPacket)this.packetFactory.apply(buf);
        client.execute(() -> NetworkUtilClient.getGravityComponent(client, entityId).ifPresent(packet::run));
    }

    public void sendToServer(P packet, ResourceLocation verifier, FriendlyByteBuf verifierInfoBuf) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        ((GravityPacket)packet).write(buf);
        buf.m_130085_(verifier);
        buf.m_130087_(verifierInfoBuf.array());
        NetworkManager.sendToServer((ResourceLocation)this.channel, (FriendlyByteBuf)buf);
    }

    public GravityVerifierRegistry<P> getVerifierRegistry() {
        return this.gravityVerifierRegistry;
    }

    public void registerClientReceiver() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)this.channel, (buf, d) -> this.receiveFromServer(Minecraft.m_91087_(), buf));
    }

    public static void init() {
        DEFAULT_GRAVITY.registerClientReceiver();
        UPDATE_GRAVITY.registerClientReceiver();
        OVERWRITE_GRAVITY.registerClientReceiver();
        INVERT_GRAVITY.registerClientReceiver();
    }
}

