/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.gui;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.HashSet;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.EnumSelectorBuilder;
import me.shedaniel.clothconfig2.impl.builders.FloatFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntSliderBuilder;
import net.arna.jcraft.common.config.BooleanOption;
import net.arna.jcraft.common.config.ConfigOption;
import net.arna.jcraft.common.config.EnumOption;
import net.arna.jcraft.common.config.FloatOption;
import net.arna.jcraft.common.config.IntOption;
import net.arna.jcraft.common.network.c2s.ConfigUpdatePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ServerConfigUI {
    public static void show(boolean editable) {
        ConfigBuilder builder = ConfigBuilder.create();
        HashSet changedOptions = new HashSet();
        for (ConfigOption option : ConfigOption.getImmutableOptions().values()) {
            ConfigCategory category = builder.getOrCreateCategory((Component)Component.m_237115_((String)("jcraft.serverconfig.category." + option.getCategory())));
            MutableComponent optionText = Component.m_237115_((String)("jcraft.serverconfig.option." + option.getKey()));
            BooleanListEntry entry = switch (option.getType()) {
                default -> throw new IncompatibleClassChangeError();
                case ConfigOption.Type.INTEGER -> {
                    IntOption intOption = (IntOption)option;
                    if (intOption.getMin() != null && intOption.getMax() != null) {
                        IntSliderBuilder sliderBuilder = builder.entryBuilder().startIntSlider((Component)optionText, intOption.getValue(), intOption.getMin().intValue(), intOption.getMax().intValue()).setDefaultValue(intOption.getDefaultValue()).setSaveConsumer(value -> {
                            intOption.setValue((int)value);
                            changedOptions.add(intOption);
                        });
                        yield sliderBuilder.build();
                    }
                    FloatFieldBuilder fieldBuilder = builder.entryBuilder().startIntField((Component)optionText, intOption.getValue()).setDefaultValue(intOption.getDefaultValue()).setSaveConsumer(value -> {
                        intOption.setValue((int)value);
                        changedOptions.add(intOption);
                    });
                    if (intOption.getMin() != null) {
                        fieldBuilder.setMin((Object)intOption.getMin());
                    } else {
                        fieldBuilder.removeMin();
                    }
                    if (intOption.getMax() != null) {
                        fieldBuilder.setMax((Object)intOption.getMax());
                    } else {
                        fieldBuilder.removeMax();
                    }
                    yield fieldBuilder.build();
                }
                case ConfigOption.Type.FLOAT -> {
                    FloatOption floatOption = (FloatOption)option;
                    FloatFieldBuilder fieldBuilder = builder.entryBuilder().startFloatField((Component)optionText, floatOption.getValue()).setDefaultValue(floatOption.getDefaultValue()).setSaveConsumer(value -> {
                        floatOption.setValue(value.floatValue());
                        changedOptions.add(floatOption);
                    });
                    if (floatOption.getMin() != null) {
                        fieldBuilder.setMin((Object)floatOption.getMin());
                    } else {
                        fieldBuilder.removeMin();
                    }
                    if (floatOption.getMax() != null) {
                        fieldBuilder.setMax((Object)floatOption.getMax());
                    } else {
                        fieldBuilder.removeMax();
                    }
                    yield fieldBuilder.build();
                }
                case ConfigOption.Type.BOOLEAN -> {
                    BooleanOption booleanOption = (BooleanOption)option;
                    BooleanToggleBuilder toggleBuilder = builder.entryBuilder().startBooleanToggle((Component)optionText, booleanOption.getValue()).setDefaultValue(booleanOption.getDefaultValue()).setSaveConsumer(value -> {
                        booleanOption.setValue((boolean)value);
                        changedOptions.add(booleanOption);
                    });
                    yield toggleBuilder.build();
                }
                case ConfigOption.Type.ENUM -> {
                    EnumOption enumOption = (EnumOption)option;
                    EnumSelectorBuilder selectorBuilder = builder.entryBuilder().startEnumSelector((Component)optionText, enumOption.getClazz(), enumOption.getValue()).setDefaultValue(enumOption.getDefaultValue()).setSaveConsumer(e -> {
                        enumOption.setValue(e.ordinal());
                        changedOptions.add(enumOption);
                    });
                    yield selectorBuilder.build();
                }
            };
            category.addEntry((AbstractConfigListEntry)entry);
        }
        builder.setEditable(editable);
        builder.setSavingRunnable(() -> NetworkManager.sendToServer((ResourceLocation)ConfigUpdatePacket.ID, (FriendlyByteBuf)ConfigOption.writeOptions(new FriendlyByteBuf(Unpooled.buffer()), changedOptions)));
        Minecraft.m_91087_().m_91152_(builder.build());
    }
}

