/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.gui.hud;

import dev.architectury.event.events.client.ClientTickEvent;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.client.rendering.FrameCounter;
import net.arna.jcraft.client.rendering.HUDAnimation;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class EpitaphOverlay {
    public static final long FRAME_TIME = 16666666L;
    private static final float VIGNETTE_INTENSITY = 5.0f;
    private static final float VIGNETTE_EXTEND = 0.5f;
    private static FrameCounter frameCounter;
    private static int lastFrame;
    private static State state;
    private static boolean shouldStop;
    private static int countdown;

    public static void preload() {
        TextureManager texMan = Minecraft.m_91087_().m_91097_();
        ExecutorService executor = Executors.newCachedThreadPool();
        for (State state : State.values()) {
            state.preload(texMan, executor);
        }
    }

    public static void start() {
        state = State.INTRO;
        frameCounter = state.getFrameCounter();
        Objects.requireNonNull(frameCounter).start();
        countdown = 100;
    }

    public static void stop() {
        if (state == State.NONE) {
            return;
        }
        shouldStop = true;
        countdown = -1;
    }

    public static void render() {
        if (!EpitaphOverlay.shouldRender() || frameCounter == null || state.getAnimation() == null) {
            return;
        }
        if (Minecraft.m_91087_().m_91104_()) {
            frameCounter.pause();
        } else {
            frameCounter.unpause();
        }
        int currentFrame = frameCounter.getCurrentFrame();
        if (currentFrame < 0 || shouldStop && currentFrame < lastFrame) {
            frameCounter = (state = state.nextState(shouldStop)).getFrameCounter();
            if (frameCounter != null) {
                frameCounter.start();
            }
            currentFrame = 0;
            shouldStop = false;
        }
        if (state == State.NONE) {
            return;
        }
        lastFrame = currentFrame;
        state.getFrame(lastFrame).render();
    }

    public static boolean shouldRender() {
        return state != State.NONE && Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON;
    }

    public static boolean shouldRenderVignette() {
        return EpitaphOverlay.shouldRender() && (state != State.INTRO || lastFrame > 10);
    }

    public static float getVignetteIntensity() {
        return state == State.INTRO ? Mth.m_14179_((float)EpitaphOverlay.getIntroProgress(), (float)0.0f, (float)5.0f) : (state == State.OUTRO ? Mth.m_14179_((float)EpitaphOverlay.getOutroProgress(), (float)5.0f, (float)150.0f) : 5.0f);
    }

    public static float getVignetteExtend() {
        return state == State.INTRO ? Mth.m_14179_((float)EpitaphOverlay.getIntroProgress(), (float)0.0f, (float)0.5f) : (state == State.OUTRO ? Mth.m_14179_((float)EpitaphOverlay.getOutroProgress(), (float)0.5f, (float)0.0f) : 0.5f);
    }

    private static float getIntroProgress() {
        return (float)(lastFrame - 11) / 9.0f;
    }

    private static float getOutroProgress() {
        return (float)lastFrame / 9.0f;
    }

    public static State getState() {
        return state;
    }

    static {
        state = State.NONE;
        shouldStop = false;
        ClientTickEvent.CLIENT_POST.register(client -> {
            if (countdown == 0) {
                EpitaphOverlay.stop();
            }
            if (countdown < 0) {
                return;
            }
            --countdown;
        });
    }

    public static enum State {
        NONE(null, false),
        INTRO("intro", false),
        LOOP("loop", true),
        OUTRO("outro", false);

        @Nullable
        private final HUDAnimation animation;
        @Nullable
        private final FrameCounter frameCounter;

        private State(String path, boolean looping) {
            String prefix = "textures/gui/epitaph_overlay/";
            this.animation = path == null ? null : HUDAnimation.create(JCraft.id("textures/gui/epitaph_overlay/" + path + "/atlas.png"), JCraft.id("textures/gui/epitaph_overlay/" + path + "/atlas.json"));
            this.frameCounter = this.animation == null ? null : this.animation.createFrameCounter(60.0f, looping);
        }

        private void preload(TextureManager textureManager, Executor executor) {
            if (this.animation == null) {
                return;
            }
            this.animation.preload(textureManager, executor);
        }

        public HUDAnimation.Frame getFrame(int index) {
            if (this.animation == null) {
                throw new IllegalStateException("NONE state has no animation.");
            }
            return this.animation.getFrame(index);
        }

        public State nextState(boolean forceOutro) {
            if (this.animation == null) {
                return this;
            }
            return forceOutro ? (this == OUTRO ? NONE : OUTRO) : (this == LOOP ? this : State.values()[(this.ordinal() + 1) % State.values().length]);
        }

        @Nullable
        public HUDAnimation getAnimation() {
            return this.animation;
        }

        @Nullable
        public FrameCounter getFrameCounter() {
            return this.frameCounter;
        }
    }
}

