/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.gui.hud;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.event.events.client.ClientGuiEvent;
import java.util.Map;
import java.util.function.Function;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.component.living.CommonCooldownsComponent;
import net.arna.jcraft.api.spec.JSpec;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.client.JClientConfig;
import net.arna.jcraft.client.JCraftClient;
import net.arna.jcraft.common.entity.stand.MandomEntity;
import net.arna.jcraft.common.util.ColorUtils;
import net.arna.jcraft.common.util.CooldownType;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public final class JCraftAbilityHud {
    public static final ResourceLocation GUI_ICONS_TEXTURE = new ResourceLocation("textures/gui/icons.png");
    private static final ResourceLocation BORDER = JCraft.id("textures/gui/ability_icons/border.png");
    private static final ResourceLocation OVERLAY = JCraft.id("textures/gui/ability_icons/overlay.png");
    static final IconPos ICON = new IconPos("icon", 10, 72);
    private static final int iconSpacing = 8;
    private static final IconPos LIGHT = new IconPos("light", 0, 16);
    private static final IconPos HEAVY = new IconPos("heavy", 0, 40);
    private static final IconPos BARRAGE = new IconPos("barrage", 0, 64);
    private static final IconPos ULT = new IconPos("ult", 0, 184);
    private static final IconPos SPECIAL_1 = new IconPos("special1", 0, 112);
    private static final IconPos SPECIAL_2 = new IconPos("special2", 0, 136);
    private static final IconPos SPECIAL_3 = new IconPos("special3", 0, 160);
    private static final IconPos UTILITY = new IconPos("utility", 0, 88);
    private static final IconPos MID_SPECIAL_1 = new IconPos("special1", 24, 88);
    private static final IconPos MID_SPECIAL_2 = new IconPos("special2", 24, 112);
    private static final IconPos MID_SPECIAL_3 = new IconPos("special3", 24, 136);
    private static final IconPos MID_ULT = new IconPos("ult", 24, 160);
    private static final IconPos COMBO_BREAKER = new IconPos("combobreaker", 24, 16);
    private static final IconPos COOLDOWN_CANCEL = new IconPos("cooldowncancel", 24, 40);
    private static final IconPos DASH = new IconPos("dash", 24, 64);
    private static final IconPos MANDOM_UTILITY = new IconPos("utility", 24, 88);
    private static final IconPos MANDOM_ULT = new IconPos("ult", 24, 112);
    private static final IconPos SPEC_HEAVY = new IconPos("heavy", 0, 40);
    private static final IconPos SPEC_BARRAGE = new IconPos("barrage", 0, 64);
    private static final IconPos SPEC_SPECIAL_1 = new IconPos("special1", 0, 88);
    private static final IconPos SPEC_SPECIAL_2 = new IconPos("special2", 0, 112);
    private static final IconPos SPEC_SPECIAL_3 = new IconPos("special3", 0, 136);
    private static final IconPos SPEC_ULT = new IconPos("ult", 0, 160);
    private static final Map<CooldownType, IconPos> STAND_ICONS = ImmutableMap.builder().put((Object)CooldownType.STAND_LIGHT, (Object)LIGHT).put((Object)CooldownType.STAND_HEAVY, (Object)HEAVY).put((Object)CooldownType.STAND_BARRAGE, (Object)BARRAGE).put((Object)CooldownType.STAND_ULTIMATE, (Object)ULT).put((Object)CooldownType.STAND_SP1, (Object)SPECIAL_1).put((Object)CooldownType.STAND_SP2, (Object)SPECIAL_2).put((Object)CooldownType.STAND_SP3, (Object)SPECIAL_3).put((Object)CooldownType.UTILITY, (Object)UTILITY).build();
    private static final Map<CooldownType, IconPos> STAND_ICONS_MID = ImmutableMap.builder().put((Object)CooldownType.STAND_LIGHT, (Object)LIGHT).put((Object)CooldownType.STAND_HEAVY, (Object)HEAVY).put((Object)CooldownType.STAND_BARRAGE, (Object)BARRAGE).put((Object)CooldownType.STAND_ULTIMATE, (Object)MID_ULT).put((Object)CooldownType.STAND_SP1, (Object)MID_SPECIAL_1).put((Object)CooldownType.STAND_SP2, (Object)MID_SPECIAL_2).put((Object)CooldownType.STAND_SP3, (Object)MID_SPECIAL_3).put((Object)CooldownType.UTILITY, (Object)UTILITY).build();
    private static final Map<CooldownType, IconPos> UNIVERSAL_ICONS = ImmutableMap.builder().put((Object)CooldownType.COMBO_BREAKER, (Object)COMBO_BREAKER).put((Object)CooldownType.COOLDOWN_CANCEL, (Object)COOLDOWN_CANCEL).put((Object)CooldownType.DASH, (Object)DASH).build();
    private static final Map<CooldownType, IconPos> SPEC_ICONS = ImmutableMap.builder().put((Object)CooldownType.HEAVY, (Object)SPEC_HEAVY).put((Object)CooldownType.BARRAGE, (Object)SPEC_BARRAGE).put((Object)CooldownType.SPECIAL1, (Object)SPEC_SPECIAL_1).put((Object)CooldownType.SPECIAL2, (Object)SPEC_SPECIAL_2).put((Object)CooldownType.SPECIAL3, (Object)SPEC_SPECIAL_3).build();
    private static final Map<CooldownType, IconPos> MANDOM_WITH_SPEC_ICONS = ImmutableMap.builder().put((Object)CooldownType.HEAVY, (Object)SPEC_HEAVY).put((Object)CooldownType.BARRAGE, (Object)SPEC_BARRAGE).put((Object)CooldownType.SPECIAL1, (Object)SPEC_SPECIAL_1).put((Object)CooldownType.SPECIAL2, (Object)SPEC_SPECIAL_2).put((Object)CooldownType.SPECIAL3, (Object)SPEC_SPECIAL_3).put((Object)CooldownType.STAND_ULTIMATE, (Object)MANDOM_ULT).put((Object)CooldownType.UTILITY, (Object)MANDOM_UTILITY).build();
    private static final ResourceLocation UNIVERSAL_ID = JCraft.id("universal");
    static int timeSinceNoCooldowns = 100;

    public static int getHudX(int scaledX, int rightOffset) {
        return switch (JClientConfig.getInstance().getUiPosition()) {
            default -> throw new IncompatibleClassChangeError();
            case JClientConfig.UIPos.LEFT -> 2;
            case JClientConfig.UIPos.RIGHT -> scaledX - rightOffset;
            case JClientConfig.UIPos.MIDDLE -> (int)((float)scaledX * 0.55f);
        };
    }

    public static void init() {
        ClientGuiEvent.RENDER_HUD.register((ctx, tickDelta) -> JCraftAbilityHud.render(ctx));
    }

    public static void render(GuiGraphics ctx) {
        Minecraft client = Minecraft.m_91087_();
        LocalPlayer player = client.f_91074_;
        if (player == null) {
            return;
        }
        ++timeSinceNoCooldowns;
        boolean isMid = JClientConfig.getInstance().getUiPosition() == JClientConfig.UIPos.MIDDLE;
        boolean useIcons = JClientConfig.getInstance().isIconHud();
        StandEntity<?, ?> stand = JUtils.getStand((LivingEntity)player);
        if (useIcons) {
            int selectedX = JCraftAbilityHud.getHudX(client.m_91268_().m_85445_(), 48);
            int selectedY = isMid ? 88 : 0;
            JSpec<?, ?> spec = JUtils.getSpec((LivingEntity)player);
            if (stand == null) {
                if (spec != null) {
                    JCraftAbilityHud.renderIcons(ctx, SPEC_ICONS, selectedX, selectedY, cooldown -> spec.getType().getId());
                }
            } else if (stand instanceof MandomEntity && spec != null) {
                JCraftAbilityHud.renderIcons(ctx, MANDOM_WITH_SPEC_ICONS, selectedX, selectedY, cooldown -> {
                    if (cooldown == CooldownType.UTILITY || cooldown == CooldownType.STAND_ULTIMATE) {
                        return stand.getStandType().getId();
                    }
                    return spec.getType().getId();
                });
            } else {
                JCraftAbilityHud.renderIcons(ctx, isMid ? STAND_ICONS_MID : STAND_ICONS, selectedX, selectedY, cooldown -> stand.getStandType().getId());
            }
            JCraftAbilityHud.renderIcons(ctx, UNIVERSAL_ICONS, selectedX, selectedY, cooldown -> UNIVERSAL_ID);
        }
    }

    public static String cooldownTypeToKeybind(CooldownType type, boolean makeShort) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case CooldownType.STAND_LIGHT -> "M1";
            case CooldownType.HEAVY, CooldownType.STAND_HEAVY, CooldownType.STAND_TOSS -> JCraftClient.generateName(JCraftClient.heavyKey.getParent(), makeShort);
            case CooldownType.BARRAGE, CooldownType.STAND_BARRAGE -> JCraftClient.generateName(JCraftClient.barrageKey.getParent(), makeShort);
            case CooldownType.ULTIMATE, CooldownType.STAND_ULTIMATE -> JCraftClient.generateName(JCraftClient.ultKey.getParent(), makeShort);
            case CooldownType.SPECIAL1, CooldownType.STAND_SP1 -> JCraftClient.generateName(JCraftClient.special1Key.getParent(), makeShort);
            case CooldownType.SPECIAL2, CooldownType.STAND_SP2 -> JCraftClient.generateName(JCraftClient.special2Key.getParent(), makeShort);
            case CooldownType.SPECIAL3, CooldownType.STAND_SP3 -> JCraftClient.generateName(JCraftClient.special3Key.getParent(), makeShort);
            case CooldownType.UTILITY, CooldownType.STAND_STANDBY -> JCraftClient.generateName(JCraftClient.utility.getParent(), makeShort);
            case CooldownType.COMBO_BREAKER -> {
                if (makeShort) {
                    yield "CB";
                }
                yield "Combo Breaker";
            }
            case CooldownType.COOLDOWN_CANCEL -> JCraftClient.generateName(JCraftClient.cooldownCancel.getParent(), makeShort);
            case CooldownType.DASH -> JCraftClient.generateName(JCraftClient.dash.getParent(), makeShort);
        };
    }

    private static void renderIcons(GuiGraphics ctx, Map<CooldownType, IconPos> icons, int selectedX, int selectedY, Function<CooldownType, ResourceLocation> type) {
        Font textRenderer = Minecraft.m_91087_().f_91065_.m_93082_();
        for (Map.Entry<CooldownType, IconPos> entry : icons.entrySet()) {
            float alpha;
            CooldownType cooldownType = entry.getKey();
            IconPos iconPos = entry.getValue();
            int iconX = iconPos.x() + selectedX;
            int iconY = iconPos.y() + selectedY;
            double cd = JCraftAbilityHud.getCooldownProgress(cooldownType);
            boolean coolingDown = cd > 0.0;
            float f = alpha = JClientConfig.getInstance().isIconHudPeekAllMoves() ? 0.1f : 0.0f;
            if (coolingDown) {
                timeSinceNoCooldowns = 0;
                alpha = 1.0f;
            }
            if (timeSinceNoCooldowns >= 100 || alpha <= 0.0f) continue;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            JCraftAbilityHud.renderBorder(ctx, iconX, iconY);
            JCraftAbilityHud.renderIcon(ctx, iconX, iconY, type.apply(cooldownType), iconPos.name());
            if (coolingDown) {
                JCraftAbilityHud.renderCooldown(ctx, cd, iconX, iconY);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String finalText = JCraftAbilityHud.cooldownTypeToKeybind(cooldownType, true);
            ctx.m_280488_(textRenderer, finalText, iconX, iconY, ColorUtils.HSBAtoRGBA(0.3f - (float)cd * 10.0f / 720.0f, cd < 1.6 ? 0.0f : 1.0f, 1.0f, alpha * 2.0f));
        }
    }

    public static void renderIcon(GuiGraphics ctx, int x, int y, ResourceLocation type, String icon) {
        ResourceLocation texture = type.m_247266_(p -> "textures/gui/ability_icons/" + p + "/" + icon + ".png");
        JCraftAbilityHud.renderAbsIcon(ctx, x, y, texture, icon);
    }

    public static void renderAbsIcon(GuiGraphics ctx, int x, int y, ResourceLocation texture, String fallback) {
        PoseStack matrices = ctx.m_280168_();
        matrices.m_85836_();
        if (!JCraftAbilityHud.isTextureAvailable(texture)) {
            texture = JCraft.id("textures/gui/ability_icons/fallback/" + fallback + ".png");
        }
        RenderSystem.enableBlend();
        ctx.m_280163_(texture, x + 2, y + 2, 0.0f, 0.0f, 18, 18, 18, 18);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        matrices.m_85849_();
    }

    public static void renderBorder(GuiGraphics ctx, int x, int y) {
        PoseStack matrices = ctx.m_280168_();
        matrices.m_85836_();
        RenderSystem.enableBlend();
        ctx.m_280163_(BORDER, x, y, 0.0f, 0.0f, 22, 22, 22, 22);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_ICONS_TEXTURE);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        matrices.m_85849_();
    }

    private static boolean isTextureAvailable(ResourceLocation textureLocation) {
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        try {
            return resourceManager.m_213713_(textureLocation).isPresent();
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static double getCooldownProgress(CooldownType type) {
        CommonCooldownsComponent cooldowns = JComponentPlatformUtils.getCooldowns((LivingEntity)Minecraft.m_91087_().f_91074_);
        int cooldown = cooldowns.getCooldown(type);
        int initialDuration = cooldowns.getInitialDuration(type);
        return cooldown > 0 && initialDuration != 0 ? JCraftAbilityHud.normalize(cooldown, 0.0, initialDuration) : -1.0;
    }

    public static void renderCooldown(GuiGraphics ctx, double cd, int x, int y) {
        PoseStack matrices = ctx.m_280168_();
        matrices.m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        ctx.m_280163_(OVERLAY, x, y + Mth.m_14107_((double)(22.0 * (1.0 - cd))), 0.0f, (float)Math.floor((1.0 - cd) * 22.0), 22, Mth.m_14165_((double)(22.0 * cd)), 22, 22);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_ICONS_TEXTURE);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        matrices.m_85849_();
    }

    private static double normalize(double value, double min, double max) {
        return (value - min) / (max - min);
    }

    private JCraftAbilityHud() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private record IconPos(String name, int x, int y) {
    }
}

