/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.gui.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.spec.JSpec;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.entity.stand.MadeInHeavenEntity;
import net.arna.jcraft.common.entity.stand.MetallicaEntity;
import net.arna.jcraft.common.entity.stand.TheSunEntity;
import net.arna.jcraft.common.spec.AnubisSpec;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class JCraftHudOverlay {
    private static final ResourceLocation EMPTY_GAUGE = JCraft.id("textures/gui/empty_gauge.png");
    private static final ResourceLocation FULL_GAUGE = JCraft.id("textures/gui/full_gauge.png");
    private static final int gaugeWidth = 42;
    private static int gaugeHeightOffset;
    private static final int GAUGE_HEIGHT_OFFSET_MAX = -65;
    private static int lastStandGauge;
    private static int standGaugeFlashTicks;
    private static final int STAND_GAUGE_FLASH_DURATION = 60;
    private static final Vector3f BLOCK_GAUGE_UNDER_THIRD;
    private static final Vector3f BLOCK_GAUGE_OVER_THIRD;
    private static final Gauge BLOCK_GAUGE;
    private static final Gauge SUN_SIZE_GAUGE;
    private static final Gauge TIME_ACCEL_GAUGE;
    private static final Gauge BLOODLUST_GAUGE;
    private static final Gauge IRON_GAUGE;

    public static void render(GuiGraphics ctx) {
        int displayBloodlust;
        JSpec<?, ?> spec;
        StandEntity<?, ?> stand;
        Minecraft client = Minecraft.m_91087_();
        int width = client.m_91268_().m_85445_();
        int height = client.m_91268_().m_85446_();
        int x = width / 2;
        LocalPlayer player = client.f_91074_;
        RenderSystem.setShader(GameRenderer::m_172817_);
        gaugeHeightOffset = -65;
        int gaugeX = x - 21;
        if (client.f_91065_.f_92991_ > 0) {
            gaugeHeightOffset -= 12;
        }
        if ((stand = JUtils.getStand((LivingEntity)player)) != null) {
            MadeInHeavenEntity madeInHeaven;
            --standGaugeFlashTicks;
            if (stand instanceof TheSunEntity) {
                TheSunEntity theSun = (TheSunEntity)stand;
                float darken = theSun.isPassive() ? 0.4f : 0.0f;
                SUN_SIZE_GAUGE.render(ctx, SUN_SIZE_GAUGE.red() - darken, SUN_SIZE_GAUGE.green() - darken, SUN_SIZE_GAUGE.blue() - darken, gaugeX, height + gaugeHeightOffset, (int)(theSun.getRawScale() * 10.0f));
            } else {
                float standGauge = stand.getStandGauge();
                Vector3f color = standGauge > stand.getMaxStandGauge() / 3.0f ? BLOCK_GAUGE_OVER_THIRD : BLOCK_GAUGE_UNDER_THIRD;
                color = new Vector3f((Vector3fc)color);
                int intStandGauge = (int)standGauge;
                if (intStandGauge > lastStandGauge) {
                    standGaugeFlashTicks = 60;
                }
                if (standGaugeFlashTicks > 0) {
                    float lighten = (float)standGaugeFlashTicks / 60.0f;
                    color.add(lighten, lighten, lighten);
                }
                BLOCK_GAUGE.render(ctx, color.x, color.y, color.z, gaugeX, height + gaugeHeightOffset, intStandGauge);
                lastStandGauge = intStandGauge;
            }
            if (stand instanceof MadeInHeavenEntity && (madeInHeaven = (MadeInHeavenEntity)stand).getAccelTime() > 0) {
                TIME_ACCEL_GAUGE.render(ctx, gaugeX, height + gaugeHeightOffset, madeInHeaven.getSpeedometer());
            }
            if (stand instanceof MetallicaEntity) {
                MetallicaEntity metallica = (MetallicaEntity)stand;
                IRON_GAUGE.render(ctx, gaugeX, height + gaugeHeightOffset, (int)metallica.getIron());
            }
        }
        if ((spec = JUtils.getSpec((LivingEntity)player)) instanceof AnubisSpec && (displayBloodlust = (int)((JComponentPlatformUtils.getMiscData((LivingEntity)player).getAttackSpeedMult() - 1.0f) * 5.0f)) > 0) {
            BLOODLUST_GAUGE.render(ctx, gaugeX, height + gaugeHeightOffset, displayBloodlust);
        }
    }

    static {
        lastStandGauge = 90;
        standGaugeFlashTicks = 0;
        BLOCK_GAUGE_UNDER_THIRD = new Vector3f(0.5f, 0.5f, 1.0f);
        BLOCK_GAUGE_OVER_THIRD = new Vector3f(0.55f, 0.8f, 1.0f);
        BLOCK_GAUGE = new Gauge(0.5f, 0.5f, 1.0f, 90);
        SUN_SIZE_GAUGE = new Gauge(1.0f, 0.7f, 0.4f, 30);
        TIME_ACCEL_GAUGE = new Gauge(1.0f, 0.8f, 0.0f, 30);
        BLOODLUST_GAUGE = new Gauge(0.8f, 0.1f, 0.2f, 5);
        IRON_GAUGE = new Gauge(0.7f, 0.7f, 0.9f, 80);
    }

    protected record Gauge(float red, float green, float blue, int max) {
        public Gauge(Vector3f color, int max) {
            this(color.x(), color.y(), color.z(), max);
        }

        public void render(GuiGraphics ctx, int x, int y, int value) {
            this.render(ctx, this.red, this.green, this.blue, x, y, value);
        }

        public void render(GuiGraphics ctx, float r, float g, float b, int x, int y, int value) {
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
            ctx.m_280163_(EMPTY_GAUGE, x, y, 0.0f, 0.0f, 42, 5, 42, 5);
            ctx.m_280163_(FULL_GAUGE, x, y, 0.0f, 0.0f, value * 42 / this.max, 5, 42, 5);
            gaugeHeightOffset -= 6;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

