/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.model;

import lombok.NonNull;
import mod.azure.azurelib.model.GeoModel;
import net.arna.jcraft.JCraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public class JBlockModel<T extends BlockEntity>
extends GeoModel<T> {
    private final ResourceLocation model;
    private final ResourceLocation texture;
    private final ResourceLocation animation;

    public JBlockModel(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.model = JCraft.id("geo/" + name + ".geo.json");
        this.texture = JCraft.id("textures/block/" + name + ".png");
        this.animation = JCraft.id("animations/" + name + ".animation.json");
    }

    @NonNull
    public ResourceLocation getModelResource(T animatable) {
        return this.model;
    }

    @NonNull
    public ResourceLocation getTextureResource(T animatable) {
        return this.texture;
    }

    @NonNull
    public ResourceLocation getAnimationResource(T animatable) {
        return this.animation;
    }
}

