/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.model;

import lombok.NonNull;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.model.GeoModel;
import net.arna.jcraft.JCraft;
import net.minecraft.resources.ResourceLocation;

public class JProjectileModel<T extends GeoAnimatable>
extends GeoModel<T> {
    private final ResourceLocation model;
    private final ResourceLocation texture;
    private final ResourceLocation animation;

    public JProjectileModel(@NonNull String name) {
        this(name, false);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
    }

    public JProjectileModel(@NonNull String name, boolean hasAnimation) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.model = JCraft.id("geo/" + name + ".geo.json");
        this.texture = JCraft.id("textures/entity/projectiles/" + name + ".png");
        this.animation = hasAnimation ? JCraft.id("animations/" + name + ".animation.json") : JCraft.id("animations/knife.animation.json");
    }

    @NonNull
    public ResourceLocation getModelResource(T animatable) {
        return this.model;
    }

    @NonNull
    public ResourceLocation getTextureResource(T animatable) {
        return this.texture;
    }

    @NonNull
    public ResourceLocation getAnimationResource(T animatable) {
        return this.animation;
    }
}

