/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.model.entity.stand;

import java.util.List;
import java.util.stream.IntStream;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.model.GeoModel;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.client.util.JClientUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class StandEntityModel<E extends StandEntity<?, ?>>
extends GeoModel<E> {
    private final StandType type;
    private final ResourceLocation model;
    private final List<ResourceLocation> skins;
    private final ResourceLocation animation;
    private final float torsoPitchOffset;
    private final float headPitchOffset;
    private final float velInfluence;

    public StandEntityModel(StandType type) {
        this(type, 0.0f, 0.0f);
    }

    public StandEntityModel(StandType type, float torsoPitchOffset, float headPitchOffset) {
        this(type, torsoPitchOffset, headPitchOffset, 90.0f);
    }

    public StandEntityModel(StandType type, float torsoPitchOffset, float headPitchOffset, float velInfluence) {
        this.type = type;
        this.model = type.getId().m_247266_(path -> "geo/" + path + ".geo.json");
        this.skins = IntStream.rangeClosed(0, 3).mapToObj(i -> type.getId().m_247266_(path -> String.format("textures/entity/stands/%s/%s.png", path, i == 0 ? "default" : "skin" + i))).toList();
        this.animation = type.getId().m_247266_(path -> "animations/" + path + ".animation.json");
        this.torsoPitchOffset = torsoPitchOffset;
        this.headPitchOffset = headPitchOffset;
        this.velInfluence = velInfluence;
    }

    public ResourceLocation getModelResource(E entity) {
        return this.model;
    }

    public ResourceLocation getTextureResource(E entity) {
        return this.skins.get(Mth.m_14045_((int)((StandEntity)entity).getSkin(), (int)0, (int)this.type.getData().getInfo().getSkinCount()));
    }

    public ResourceLocation getAnimationResource(E entity) {
        return this.animation;
    }

    public void setCustomAnimations(E animatable, long instanceId, AnimationState<E> animationState) {
        super.setCustomAnimations(animatable, instanceId, animationState);
        if (this.skipCustomAnimations() || !((StandEntity)animatable).hasUser()) {
            return;
        }
        JClientUtils.animateGenericHumanoid(this, animatable, ((StandEntity)animatable).getUser(), animationState.getPartialTick(), true, true, this.torsoPitchOffset, this.headPitchOffset, this.velInfluence);
    }

    protected boolean skipCustomAnimations() {
        return false;
    }
}

