/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.net;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.networking.NetworkManager;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.SpeedModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.registry.JPacketRegistry;
import net.arna.jcraft.api.registry.JParticleTypeRegistry;
import net.arna.jcraft.api.spec.JSpec;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.client.JClientConfig;
import net.arna.jcraft.client.JCraftClient;
import net.arna.jcraft.client.gui.ServerConfigUI;
import net.arna.jcraft.client.gui.hud.EpitaphOverlay;
import net.arna.jcraft.client.renderer.effects.AttackHitboxEffectRenderer;
import net.arna.jcraft.client.renderer.effects.TimeErasePredictionEffectRenderer;
import net.arna.jcraft.client.rendering.DamageIndicatorManager;
import net.arna.jcraft.client.rendering.handler.CrimsonShaderHandler;
import net.arna.jcraft.client.rendering.handler.ZaWarudoShaderHandler;
import net.arna.jcraft.client.util.JClientUtils;
import net.arna.jcraft.common.config.ConfigOption;
import net.arna.jcraft.common.data.AttackerDataLoader;
import net.arna.jcraft.common.entity.stand.MadeInHeavenEntity;
import net.arna.jcraft.common.item.StoneMaskItem;
import net.arna.jcraft.common.network.s2c.ShaderActivationPacket;
import net.arna.jcraft.common.network.s2c.TimeAccelStatePacket;
import net.arna.jcraft.common.splatter.Splatter;
import net.arna.jcraft.common.util.DimensionData;
import net.arna.jcraft.common.util.IJCraftAnimatedPlayer;
import net.arna.jcraft.common.util.IJExplosion;
import net.arna.jcraft.common.util.JExplosionModifier;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public final class ClientPacketHandler {
    private static final int NUM_MAGNETIC_CIRCLES = 16;
    private static final int NUM_MAGNETIC_PARTICLES = 32;

    public static void init() {
        ClientPacketHandler.register(JPacketRegistry.S2C_SERVER_CHANNEL_FEEDBACK, ClientPacketHandler::handleChannelFeedback);
        ClientPacketHandler.register(JPacketRegistry.S2C_PLAYER_ANIMATION, ClientPacketHandler::handleAnimation);
        ClientPacketHandler.register(JPacketRegistry.S2C_SHADER_ACTIVATION, ClientPacketHandler::handleShaderActivation);
        ClientPacketHandler.register(JPacketRegistry.S2C_SHADER_DEACTIVATION, ClientPacketHandler::handleShaderDeactivation);
        ClientPacketHandler.register(JPacketRegistry.S2C_TIME_ACCELERATION_STATE, ClientPacketHandler::handleTimeAccelState);
        ClientPacketHandler.register(JPacketRegistry.S2C_EPITAPH_STATE, ClientPacketHandler::handleEpitaphOverlayState);
        ClientPacketHandler.register(JPacketRegistry.S2C_TIME_ERASE_PREDICTION_STATE, ClientPacketHandler::handlePredictionState);
        ClientPacketHandler.register(JPacketRegistry.S2C_SERVER_CONFIG, ClientPacketHandler::handleServerConfig);
        ClientPacketHandler.register(JPacketRegistry.S2C_J_EXPLOSION, ClientPacketHandler::handleJExplosion);
        ClientPacketHandler.register(JPacketRegistry.S2C_COMBO_COUNTER, ClientPacketHandler::handleComboCounter);
        ClientPacketHandler.register(JPacketRegistry.S2C_TIME_STOP, ClientPacketHandler::handleTimeStop);
        ClientPacketHandler.register(JPacketRegistry.S2C_SPLATTER, ClientPacketHandler::handleSplatter);
        ClientPacketHandler.register(JPacketRegistry.S2C_STAND_HURT, ClientPacketHandler::handleStandHurt);
        ClientPacketHandler.register(JPacketRegistry.S2C_PREDICTION_UPDATE, ClientPacketHandler::handlePrediction);
        ClientPacketHandler.register(JPacketRegistry.S2C_MAGNETIC_FIELD_PARTICLE, ClientPacketHandler::handleMagneticFieldParticle);
        ClientPacketHandler.register(JPacketRegistry.S2C_ATTACKER_DATA, ClientPacketHandler::handleAttackerData);
        ClientPacketHandler.register(JPacketRegistry.S2C_MANDOM_DATA, ClientPacketHandler::handleMandomData);
        ClientPacketHandler.register(JPacketRegistry.S2C_STONE_MASK_CLENCH, ClientPacketHandler::handleStoneMaskClench);
        ClientPacketHandler.register(JPacketRegistry.S2C_IPS_TRIGGERED, ClientPacketHandler::handleIPSTriggered);
        ClientPacketHandler.register(JPacketRegistry.S2C_DAMAGE_NUMBER, ClientPacketHandler::handleDamageNumber);
    }

    private static void handleDamageNumber(@NonNull Minecraft client, FriendlyByteBuf buf) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        int entityId = buf.readInt();
        float damageAmount = buf.readFloat();
        client.execute(() -> {
            Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(entityId);
            if (entity != null) {
                DamageIndicatorManager.spawnDamageNumber(entity, damageAmount);
            }
        });
    }

    private static void handleIPSTriggered(@NonNull Minecraft client, FriendlyByteBuf buf) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        JCraftClient.markIPSTriggered();
    }

    private static void handleStoneMaskClench(@NonNull Minecraft client, FriendlyByteBuf buf) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (client.f_91073_ == null) {
            return;
        }
        Entity entity = client.f_91073_.m_6815_(buf.m_130242_());
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            StoneMaskItem.clench(livingEntity);
        }
    }

    private static void handleAttackerData(@NonNull Minecraft client, FriendlyByteBuf buf) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        AttackerDataLoader.readFromBuffer(buf);
    }

    private static void handleMagneticFieldParticle(@NonNull Minecraft client, FriendlyByteBuf buf) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        double strength = buf.readDouble();
        Vec3 pos = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        client.execute(() -> {
            for (int i = 0; i < 16; ++i) {
                double phi = (double)i * Math.PI * 2.0 / 16.0;
                Vec3 direction = new Vec3(Math.cos(phi), 0.0, Math.sin(phi));
                Vec3 basePos = pos.m_82549_(direction.m_82490_(strength / 2.0));
                for (int j = 0; j < 32; ++j) {
                    double phi_2 = (double)j * Math.PI * 2.0 / 32.0;
                    Vec3 horizontalOffset = direction.m_82490_(Math.cos(phi_2));
                    double verticalOffset = Math.sin(phi_2);
                    client.f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_123808_, basePos.f_82479_ + horizontalOffset.f_82479_, basePos.f_82480_ + horizontalOffset.f_82480_ + verticalOffset * strength / 2.0, basePos.f_82481_ + horizontalOffset.f_82481_, 0.0, 0.0, 0.0);
                }
            }
        });
    }

    private static void handlePrediction(@NonNull Minecraft client, FriendlyByteBuf buf) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (client.f_91073_ == null) {
            return;
        }
        int size = buf.readInt();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            int entID = buf.readInt();
            Vec3 predictedPos = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
            client.execute(() -> {
                Entity ent = client.f_91073_.m_6815_(entID);
                if (ent == null) {
                    return;
                }
                ent.m_217001_().m_238033_(predictedPos);
            });
        }
    }

    private static void handleTimeStop(@NonNull Minecraft client, FriendlyByteBuf buf) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (client.f_91073_ == null) {
            return;
        }
        boolean isStart = buf.readBoolean();
        int entID = buf.readInt();
        if (isStart) {
            Vec3 position = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
            ResourceKey registryKey = buf.m_236801_(Registries.f_256858_);
            int time = buf.readInt();
            client.execute(() -> {
                Entity ent = client.f_91073_.m_6815_(entID);
                if (!(ent instanceof LivingEntity)) {
                    return;
                }
                LivingEntity livingEntity = (LivingEntity)ent;
                JClientUtils.activeTimestops.add(new DimensionData(livingEntity, position, (ResourceKey<Level>)registryKey, time));
            });
        } else {
            JClientUtils.removeTimestop(entID);
        }
    }

    private static void register(ResourceLocation id, Consumer<FriendlyByteBuf> handler) {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)id, (buf, context) -> handler.accept(buf));
    }

    private static void register(ResourceLocation id, BiConsumer<Minecraft, FriendlyByteBuf> handler) {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)id, (buf, context) -> handler.accept(Minecraft.m_91087_(), buf));
    }

    public static void handleAnimation(@NonNull Minecraft client, FriendlyByteBuf buf) {
        float animationSpeed;
        int moveStun;
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (client.f_91073_ == null) {
            return;
        }
        int entID = buf.readInt();
        String animID = buf.m_130277_();
        boolean isSpec = buf.readBoolean();
        if (isSpec) {
            moveStun = buf.readInt();
            animationSpeed = buf.readFloat();
        } else {
            moveStun = 0;
            animationSpeed = 0.0f;
        }
        client.execute(() -> {
            Entity ent = client.f_91073_.m_6815_(entID);
            if (ent instanceof Player) {
                Player player = (Player)ent;
                ModifierLayer<IAnimation> animationContainer = ((IJCraftAnimatedPlayer)player).jcraft_getModAnimation();
                KeyframeAnimation anim = PlayerAnimationRegistry.getAnimation((ResourceLocation)JCraft.id(animID));
                if (anim == null) {
                    JCraft.LOGGER.error(String.format("Tried to play null animation on player: %s, in world %s", player, client.f_91073_));
                    return;
                }
                if (animationContainer.size() > 0) {
                    animationContainer.removeModifier(0);
                }
                if (isSpec) {
                    JSpec<?, ?> spec = JUtils.getSpec((LivingEntity)player);
                    if (spec == null) {
                        JCraft.LOGGER.error(String.format("Tried to set spec animation values on player without spec: %s, in world %s", player, client.f_91073_));
                    } else {
                        spec.moveStun = moveStun;
                        animationContainer.addModifierBefore((AbstractModifier)new SpeedModifier(animationSpeed));
                    }
                }
                animationContainer.setAnimation((IAnimation)new KeyframeAnimationPlayer(anim));
            }
        });
    }

    public static void handleChannelFeedback(@NonNull Minecraft client, FriendlyByteBuf buf) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (client.f_91073_ == null || client.f_91074_ == null) {
            return;
        }
        short control = buf.readShort();
        switch (control) {
            case 1: {
                int count = buf.m_130242_();
                AABB[] boxes = new AABB[count];
                for (int i = 0; i < count; ++i) {
                    double minX = buf.readDouble();
                    double minY = buf.readDouble();
                    double minZ = buf.readDouble();
                    double maxX = buf.readDouble();
                    double maxY = buf.readDouble();
                    double maxZ = buf.readDouble();
                    boxes[i] = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
                }
                RenderSystem.recordRenderCall(() -> AttackHitboxEffectRenderer.addHitboxes(boxes));
                break;
            }
            case 2: {
                double posX = buf.readDouble();
                double posY = buf.readDouble();
                double posZ = buf.readDouble();
                double sizeX = Mth.m_14008_((double)buf.readDouble(), (double)0.1, (double)100.0);
                double sizeY = Mth.m_14008_((double)buf.readDouble(), (double)0.1, (double)100.0);
                double sizeZ = Mth.m_14008_((double)buf.readDouble(), (double)0.1, (double)100.0);
                client.execute(() -> {
                    Random random = new Random();
                    for (int h = 0; h < 8; ++h) {
                        client.f_91073_.m_7106_((ParticleOptions)JParticleTypeRegistry.KCPARTICLE.get(), posX + random.nextDouble(sizeX) - sizeX / 2.0, posY + random.nextDouble(sizeY), posZ + random.nextDouble(sizeZ) - sizeZ / 2.0, 0.0, 0.0, 0.0);
                    }
                });
                break;
            }
            case 3: {
                double x = buf.readDouble();
                double y = buf.readDouble();
                double z = buf.readDouble();
                JParticleType particleType = (JParticleType)buf.m_130066_(JParticleType.class);
                client.execute(() -> client.f_91073_.m_6493_((ParticleOptions)particleType.getParticleType(), true, x, y, z, 0.0, 0.0, 0.0));
                break;
            }
            case 5: {
                double x = buf.readDouble();
                double y = buf.readDouble();
                double z = buf.readDouble();
                JParticleType particleType = (JParticleType)buf.m_130066_(JParticleType.class);
                int sparkCount = buf.readInt();
                double speed = buf.readDouble();
                client.execute(() -> {
                    Random random = new Random();
                    SimpleParticleType type = particleType.getParticleType();
                    for (int i = 0; i < sparkCount; ++i) {
                        Vec3 vel = JUtils.randUnitVec(random);
                        client.f_91073_.m_6493_((ParticleOptions)type, false, x + random.nextGaussian() * 0.33, y + random.nextGaussian() * 0.33, z + random.nextGaussian() * 0.33, vel.f_82479_ * speed, vel.f_82480_ * speed, vel.f_82481_ * speed);
                    }
                });
                break;
            }
            case 7: {
                int entID = buf.readInt();
                Vec3 originalPos = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
                client.execute(() -> {
                    Entity ent = client.f_91073_.m_6815_(entID);
                    if (ent == null) {
                        return;
                    }
                    Vec3 currentPos = ent.m_146892_();
                    Vec3 originalToCurrent = currentPos.m_82546_(originalPos).m_82541_();
                    for (double h = 0.0; h < currentPos.m_82554_(originalPos); h += 1.0) {
                        client.f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_175830_, originalPos.f_82479_ + originalToCurrent.f_82479_ * h, originalPos.f_82480_ + originalToCurrent.f_82480_ * h, originalPos.f_82481_ + originalToCurrent.f_82481_ * h, -originalToCurrent.f_82479_, -originalToCurrent.f_82480_, -originalToCurrent.f_82481_);
                    }
                });
                break;
            }
            case 9: {
                double v1x = buf.readDouble();
                double v1y = buf.readDouble();
                double v1z = buf.readDouble();
                double v2x = buf.readDouble();
                double v2y = buf.readDouble();
                double v2z = buf.readDouble();
                double oX = buf.readDouble();
                double oY = buf.readDouble();
                double oZ = buf.readDouble();
                boolean inRange = buf.readBoolean();
                client.execute(() -> {
                    double z;
                    double y;
                    double x;
                    int h;
                    Random random = new Random();
                    for (h = 0; h < 16; ++h) {
                        x = v1x + random.nextDouble(v2x) - v2x / 2.0;
                        y = v1y + random.nextDouble(v2y) - v2y / 2.0;
                        z = v1z + random.nextDouble(v2z) - v2z / 2.0;
                        client.f_91073_.m_7106_((ParticleOptions)(inRange ? ParticleTypes.f_175829_ : ParticleTypes.f_175827_), x, y, z, 0.0, 0.0, 0.0);
                    }
                    for (h = 0; h < 8; ++h) {
                        x = oX + random.nextDouble(v2x) - v2x / 2.0;
                        y = oY + random.nextDouble(v2y) - v2y / 2.0;
                        z = oZ + random.nextDouble(v2z) - v2z / 2.0;
                        client.f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_175827_, x, y, z, 0.0, 0.0, 0.0);
                    }
                });
                break;
            }
            case 10: {
                Random random = new Random();
                double x = buf.readDouble();
                double y = buf.readDouble();
                double z = buf.readDouble();
                client.execute(() -> {
                    for (int h = 0; h < 360; ++h) {
                        client.f_91073_.m_7106_((ParticleOptions)(random.nextInt(0, 5) > 3 ? ParticleTypes.f_123756_ : ParticleTypes.f_123744_), x + Math.sin(h) * 4.0 + random.nextGaussian() * 2.0, y + random.nextGaussian() * 1.5, z + Math.cos(h) * 4.0 + random.nextGaussian() * 2.0, Math.sin((double)h + 1.57) / 4.0, 0.0, Math.cos((double)h + 1.57) / 4.0);
                    }
                });
                break;
            }
            case 11: {
                double x = buf.readDouble();
                double y = buf.readDouble();
                double z = buf.readDouble();
                double size = buf.readDouble();
                client.execute(() -> {
                    Random random = new Random();
                    int h = 0;
                    while ((double)h < size * 128.0) {
                        client.f_91073_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, Blocks.f_49992_.m_49966_()), x + random.nextGaussian() * size, y + random.nextGaussian() * size, z + random.nextGaussian() * size, 0.0, 0.0, 0.0);
                        ++h;
                    }
                });
                break;
            }
            case 13: {
                int entID = buf.readInt();
                client.execute(() -> {
                    Entity ent = client.f_91073_.m_6815_(entID);
                    if (ent instanceof Player) {
                        Player player = (Player)ent;
                        ModifierLayer<IAnimation> animationContainer = ((IJCraftAnimatedPlayer)player).jcraft_getModAnimation();
                        animationContainer.setAnimation(null);
                    }
                });
            }
        }
    }

    public static void handleMandomData(@NonNull Minecraft client, FriendlyByteBuf buf) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        int entID = buf.readInt();
        Vec3 originalPos = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        client.execute(() -> {
            Entity ent = client.f_91073_.m_6815_(entID);
            if (ent == null || ent.m_20145_() || JClientUtils.shouldNotRender(ent) || ent instanceof StandEntity) {
                return;
            }
            Vec3 currentPos = ent.m_20182_();
            Vec3 originalToCurrent = currentPos.m_82546_(originalPos).m_82541_();
            for (double h = 0.0; h < currentPos.m_82554_(originalPos); h += 1.0) {
                client.f_91073_.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.2f, 0.6f), 1.0f), originalPos.f_82479_ + originalToCurrent.f_82479_ * h, originalPos.f_82480_ + originalToCurrent.f_82480_ * h, originalPos.f_82481_ + originalToCurrent.f_82481_ * h, -originalToCurrent.f_82479_, -originalToCurrent.f_82480_, -originalToCurrent.f_82481_);
            }
        });
    }

    public static void handleShaderActivation(@NonNull Minecraft client, FriendlyByteBuf buf) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        int delay = buf.readInt();
        int duration = buf.readInt();
        ShaderActivationPacket.Type type = ShaderActivationPacket.Type.byName(buf.m_130277_());
        ClientLevel world = client.f_91073_;
        if (world == null) {
            return;
        }
        switch (type) {
            case NONE: {
                break;
            }
            case ZA_WARUDO: {
                int id = buf.readInt();
                client.execute(() -> ClientPacketHandler.lambda$handleShaderActivation$17((Level)world, id, client, duration));
                break;
            }
            case CRIMSON: {
                client.execute(() -> {
                    if (!JClientConfig.getInstance().isTimeEraseShader()) {
                        return;
                    }
                    CrimsonShaderHandler crimsonShaderHandler = CrimsonShaderHandler.INSTANCE;
                    crimsonShaderHandler.effectLength = duration;
                    crimsonShaderHandler.shouldRender = true;
                });
            }
        }
    }

    public static void handleShaderDeactivation(@NonNull Minecraft client, FriendlyByteBuf buf) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        ShaderActivationPacket.Type type = ShaderActivationPacket.Type.byName(buf.m_130277_());
        ClientLevel world = client.f_91073_;
        if (world != null) {
            switch (type) {
                case NONE: {
                    break;
                }
                case ZA_WARUDO: {
                    client.execute(() -> {
                        ZaWarudoShaderHandler zaWarudoShaderHandler = ZaWarudoShaderHandler.INSTANCE;
                        zaWarudoShaderHandler.shouldRender = false;
                        zaWarudoShaderHandler.renderingEffect = false;
                    });
                    break;
                }
                case CRIMSON: {
                    client.execute(() -> {
                        CrimsonShaderHandler crimsonShaderHandler = CrimsonShaderHandler.INSTANCE;
                        crimsonShaderHandler.shouldRender = false;
                        crimsonShaderHandler.renderingEffect = false;
                    });
                }
            }
        }
    }

    public static void handleTimeAccelState(@NonNull Minecraft client, FriendlyByteBuf buf) {
        MadeInHeavenEntity mih;
        Entity e;
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        TimeAccelStatePacket.State state = (TimeAccelStatePacket.State)buf.m_130066_(TimeAccelStatePacket.State.class);
        Entity entity = e = client.f_91073_ == null ? null : client.f_91073_.m_6815_(buf.m_130242_());
        if (!(e instanceof MadeInHeavenEntity) || !(mih = (MadeInHeavenEntity)e).m_6084_()) {
            return;
        }
        switch (state) {
            case START: {
                int duration = buf.m_130242_();
                long startTime = buf.readLong();
                TimeAccelStatePacket.addAcceleration(mih.m_19879_(), (int)((long)duration - (System.currentTimeMillis() - startTime) / 50L), startTime);
                break;
            }
            case STOP: {
                TimeAccelStatePacket.removeAcceleration(mih.m_19879_());
            }
        }
    }

    public static void handleEpitaphOverlayState(@NonNull Minecraft client, FriendlyByteBuf buf) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        boolean start = buf.readBoolean();
        client.execute(() -> {
            if (start) {
                EpitaphOverlay.start();
            } else {
                EpitaphOverlay.stop();
            }
        });
    }

    public static void handlePredictionState(@NonNull Minecraft client, FriendlyByteBuf buf) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        boolean start = buf.readBoolean();
        int length = start ? buf.m_130242_() : 0;
        client.execute(() -> {
            if (start) {
                TimeErasePredictionEffectRenderer.startEffect(length);
            } else {
                TimeErasePredictionEffectRenderer.stopEffect();
            }
        });
    }

    public static void handleServerConfig(@NonNull Minecraft client, FriendlyByteBuf buf) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        boolean editable = buf.readBoolean();
        boolean show = buf.readBoolean();
        ConfigOption.readOptions(buf);
        if (show) {
            client.execute(() -> ServerConfigUI.show(editable));
        }
    }

    private static void handleJExplosion(@NonNull Minecraft client, FriendlyByteBuf buf) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        ClientboundExplodePacket nativePacket = new ClientboundExplodePacket(buf);
        JExplosionModifier modifier = buf.readBoolean() ? JExplosionModifier.read(buf) : null;
        client.execute(() -> {
            Explosion explosion = new Explosion((Level)client.f_91073_, null, nativePacket.m_132132_(), nativePacket.m_132133_(), nativePacket.m_132134_(), nativePacket.m_132135_(), nativePacket.m_132136_());
            ((IJExplosion)explosion).jcraft$setModifier(modifier);
            explosion.m_46075_(true);
            Objects.requireNonNull(client.f_91074_).m_20256_(client.f_91074_.m_20184_().m_82520_((double)nativePacket.m_132127_(), (double)nativePacket.m_132130_(), (double)nativePacket.m_132131_()));
        });
    }

    private static void handleComboCounter(@NonNull Minecraft minecraftClient, FriendlyByteBuf buf) {
        if (minecraftClient == null) {
            throw new NullPointerException("minecraftClient is marked non-null but is null");
        }
        JCraftClient.comboCounter = buf.readInt();
        if (JCraftClient.comboCounter == 1) {
            JCraftClient.markComboStarted();
        }
        JCraftClient.damageScaling = buf.readFloat();
        JCraftClient.framesSinceCounted = 0;
    }

    private static void handleSplatter(Minecraft client, FriendlyByteBuf buf) {
        ClientLevel world = client.f_91073_;
        if (world == null) {
            return;
        }
        Splatter splatter = JUtils.getSplatterManager((Level)world).readSplatter(buf);
        long ageMs = (long)splatter.getType().getMaxAge() * 50L;
        AttackHitboxEffectRenderer.addHitbox(splatter.getMainBox(), ageMs, true);
        splatter.getSections().stream().filter(section -> !section.isRemoved()).forEach(section -> AttackHitboxEffectRenderer.addHitbox(section.getHitBox(), ageMs, true));
    }

    private static void handleStandHurt(Minecraft client, FriendlyByteBuf buf) {
        int entityId = buf.m_130242_();
        client.execute(() -> {
            if (client.f_91073_ == null) {
                return;
            }
            Entity entity = client.f_91073_.m_6815_(entityId);
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity living = (LivingEntity)entity;
            living.f_19802_ = 20;
            living.f_20917_ = 10;
            living.f_20916_ = 10;
        });
    }

    private ClientPacketHandler() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static /* synthetic */ void lambda$handleShaderActivation$17(Level world, int id, Minecraft client, int duration) {
        Entity sourceShader = world.m_6815_(id);
        if (sourceShader instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)sourceShader;
            ZaWarudoShaderHandler zaWarudoShaderHandler = ZaWarudoShaderHandler.INSTANCE;
            zaWarudoShaderHandler.shaderSourceEntity = Optional.of(livingEntity).orElse((LivingEntity)client.f_91074_);
            zaWarudoShaderHandler.effectLength = duration;
            zaWarudoShaderHandler.shouldRender = true;
        }
    }
}

