/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.renderer.effects;

import com.google.common.collect.EvictingQueue;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.longs.LongLongPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public final class AttackHitboxEffectRenderer {
    private static final Object $LOCK = new Object[0];
    private static final Queue<Pair<LongLongPair, AABB>> hitboxes = EvictingQueue.create((int)8);
    private static final List<Pair<LongLongPair, AABB>> highPriorityBoxes = new ArrayList<Pair<LongLongPair, AABB>>();

    public static void init() {
    }

    public static void addHitboxes(Iterable<AABB> boxes) {
        for (AABB box : boxes) {
            AttackHitboxEffectRenderer.addHitbox(box);
        }
    }

    public static void addHitboxes(AABB[] boxes) {
        for (AABB box : boxes) {
            AttackHitboxEffectRenderer.addHitbox(box);
        }
    }

    public static void addHitbox(AABB box) {
        AttackHitboxEffectRenderer.addHitbox(box, 2500L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addHitbox(AABB box, long duration, boolean highPriority) {
        Object object = $LOCK;
        synchronized (object) {
            (highPriority ? highPriorityBoxes : hitboxes).add((Pair<LongLongPair, AABB>)Pair.of((Object)LongLongPair.of((long)Util.m_137574_(), (long)duration), (Object)box));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void render(PoseStack matrices, Vec3 camPos, LevelRenderer worldRenderer, MultiBufferSource consumerProvider) {
        Object object = $LOCK;
        synchronized (object) {
            if (!Minecraft.m_91087_().m_91290_().m_114377_()) {
                return;
            }
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            matrices.m_85836_();
            AttackHitboxEffectRenderer.renderBoxes(consumerProvider, matrices, camPos, hitboxes);
            AttackHitboxEffectRenderer.renderBoxes(consumerProvider, matrices, camPos, highPriorityBoxes);
            matrices.m_85849_();
        }
    }

    private static void renderBoxes(MultiBufferSource consumerProvider, PoseStack matrices, Vec3 camPos, Collection<Pair<LongLongPair, AABB>> boxes) {
        Iterator<Pair<LongLongPair, AABB>> iterator = boxes.iterator();
        while (iterator.hasNext()) {
            Pair<LongLongPair, AABB> pair = iterator.next();
            AttackHitboxEffectRenderer.renderBox(consumerProvider, (AABB)pair.right(), matrices, camPos);
            if (Util.m_137574_() - ((LongLongPair)pair.left()).leftLong() <= ((LongLongPair)pair.left()).rightLong()) continue;
            iterator.remove();
        }
    }

    private static void renderBox(MultiBufferSource consumerProvider, AABB box, PoseStack matrices, Vec3 camPos) {
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder quadsVc = tess.m_85915_();
        quadsVc.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.enableBlend();
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        int c = 1425997824;
        float minX = (float)(box.f_82288_ - camPos.f_82479_);
        float minY = (float)(box.f_82289_ - camPos.f_82480_);
        float minZ = (float)(box.f_82290_ - camPos.f_82481_);
        float maxX = (float)(box.f_82291_ - camPos.f_82479_);
        float maxY = (float)(box.f_82292_ - camPos.f_82480_);
        float maxZ = (float)(box.f_82293_ - camPos.f_82481_);
        Matrix4f m = matrices.m_85850_().m_252922_();
        quadsVc.m_252986_(m, minX, maxY, minZ).m_193479_(1425997824).m_5752_();
        quadsVc.m_252986_(m, minX, maxY, maxZ).m_193479_(1425997824).m_5752_();
        quadsVc.m_252986_(m, maxX, maxY, maxZ).m_193479_(1425997824).m_5752_();
        quadsVc.m_252986_(m, maxX, maxY, minZ).m_193479_(1425997824).m_5752_();
        quadsVc.m_252986_(m, minX, minY, minZ).m_193479_(1425997824).m_5752_();
        quadsVc.m_252986_(m, maxX, minY, minZ).m_193479_(1425997824).m_5752_();
        quadsVc.m_252986_(m, maxX, minY, maxZ).m_193479_(1425997824).m_5752_();
        quadsVc.m_252986_(m, minX, minY, maxZ).m_193479_(1425997824).m_5752_();
        quadsVc.m_252986_(m, minX, minY, minZ).m_193479_(1425997824).m_5752_();
        quadsVc.m_252986_(m, minX, maxY, minZ).m_193479_(1425997824).m_5752_();
        quadsVc.m_252986_(m, maxX, maxY, minZ).m_193479_(1425997824).m_5752_();
        quadsVc.m_252986_(m, maxX, minY, minZ).m_193479_(1425997824).m_5752_();
        quadsVc.m_252986_(m, maxX, minY, minZ).m_193479_(1425997824).m_5752_();
        quadsVc.m_252986_(m, maxX, maxY, minZ).m_193479_(1425997824).m_5752_();
        quadsVc.m_252986_(m, maxX, maxY, maxZ).m_193479_(1425997824).m_5752_();
        quadsVc.m_252986_(m, maxX, minY, maxZ).m_193479_(1425997824).m_5752_();
        quadsVc.m_252986_(m, minX, minY, maxZ).m_193479_(1425997824).m_5752_();
        quadsVc.m_252986_(m, maxX, minY, maxZ).m_193479_(1425997824).m_5752_();
        quadsVc.m_252986_(m, maxX, maxY, maxZ).m_193479_(1425997824).m_5752_();
        quadsVc.m_252986_(m, minX, maxY, maxZ).m_193479_(1425997824).m_5752_();
        quadsVc.m_252986_(m, minX, minY, minZ).m_193479_(1425997824).m_5752_();
        quadsVc.m_252986_(m, minX, minY, maxZ).m_193479_(1425997824).m_5752_();
        quadsVc.m_252986_(m, minX, maxY, maxZ).m_193479_(1425997824).m_5752_();
        quadsVc.m_252986_(m, minX, maxY, minZ).m_193479_(1425997824).m_5752_();
        tess.m_85914_();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableDepthTest();
        VertexConsumer linesVc = Objects.requireNonNull(consumerProvider).m_6299_((RenderType)RenderType.f_110371_);
        AABB newBox = new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        LevelRenderer.m_109646_((PoseStack)matrices, (VertexConsumer)linesVc, (AABB)newBox, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    private AttackHitboxEffectRenderer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

