/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.renderer.effects;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.component.world.CommonShockwaveHandlerComponent;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class ShockwaveEffectRenderer {
    private static final Map<CommonShockwaveHandlerComponent.Shockwave.Type, List<ResourceLocation>> TEXTURES = new EnumMap<CommonShockwaveHandlerComponent.Shockwave.Type, List<ResourceLocation>>(CommonShockwaveHandlerComponent.Shockwave.Type.class);
    private static final List<CommonShockwaveHandlerComponent.Shockwave> toRender;

    public static void render(PoseStack stack, Vec3 camPos, ClientLevel world, MultiBufferSource consumerProvider) {
        CommonShockwaveHandlerComponent shockwaveHandler = JComponentPlatformUtils.getShockwaveHandler((Level)world);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.setShader(GameRenderer::m_172835_);
        toRender.clear();
        toRender.addAll(shockwaveHandler.getShockwaves());
        for (CommonShockwaveHandlerComponent.Shockwave shockwave : toRender) {
            stack.m_85836_();
            stack.m_85837_(shockwave.getX() - camPos.f_82479_, shockwave.getY() - camPos.f_82480_, shockwave.getZ() - camPos.f_82481_);
            stack.m_252781_(Axis.f_252436_.m_252977_(-shockwave.getYaw()));
            stack.m_252781_(Axis.f_252529_.m_252977_(shockwave.getPitch()));
            Matrix4f mat = stack.m_85850_().m_252922_();
            int blockLight = world.m_45517_(LightLayer.BLOCK, shockwave.getBlockPos());
            int skyLight = world.m_45517_(LightLayer.SKY, shockwave.getBlockPos());
            int light = LightTexture.m_109885_((int)blockLight, (int)skyLight);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURES.get((Object)shockwave.getType()).get(shockwave.getFrame()));
            Tesselator tess = Tesselator.m_85913_();
            BufferBuilder buff = tess.m_85915_();
            buff.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85820_);
            float min = -0.5f * shockwave.getScale();
            float max = 0.5f * shockwave.getScale();
            buff.m_252986_(mat, min, min, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_85969_(light).m_5752_();
            buff.m_252986_(mat, max, min, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_85969_(light).m_5752_();
            buff.m_252986_(mat, max, max, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_85969_(light).m_5752_();
            buff.m_252986_(mat, min, max, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_85969_(light).m_5752_();
            tess.m_85914_();
            stack.m_85849_();
        }
    }

    static {
        for (CommonShockwaveHandlerComponent.Shockwave.Type type : CommonShockwaveHandlerComponent.Shockwave.Type.values()) {
            ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
            for (int i = 0; i < 6; ++i) {
                ResourceLocation id = JCraft.id("textures/effect/shockwave/" + type.getName() + "_" + i + ".png");
                list.add(id);
            }
            TEXTURES.put(type, list);
        }
        toRender = new ArrayList<CommonShockwaveHandlerComponent.Shockwave>();
    }
}

