/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.renderer.effects;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.arna.jcraft.common.splatter.JSplatterManager;
import net.arna.jcraft.common.splatter.SplatterSection;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SplatterEffectRenderer {
    public static void render(PoseStack matrices, Vec3 camPos, ClientLevel world, float tickDelta) {
        JSplatterManager splatterManager = JUtils.getSplatterManager((Level)world);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(GameRenderer::m_172835_);
        splatterManager.iterateSplatters(splatter -> {
            if (splatter.isRemoved()) {
                return;
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)splatter.getType().getTexture());
            matrices.m_85836_();
            Tesselator tess = Tesselator.m_85913_();
            BufferBuilder buf = tess.m_85915_();
            buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85820_);
            float alpha = splatter.getStrength(tickDelta);
            for (SplatterSection section : splatter.getSections()) {
                if (section.isRemoved()) continue;
                SplatterEffectRenderer.renderSection(section, buf, matrices, camPos, alpha, splatter.getOffset());
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buf.m_231175_());
            matrices.m_85849_();
        });
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
    }

    private static void renderSection(SplatterSection section, BufferBuilder buf, PoseStack matrices, Vec3 camPos, float alpha, float offset) {
        matrices.m_85836_();
        Vector3f offsetVec = section.getDirection().m_253071_();
        offsetVec.mul(offset, offset, offset);
        matrices.m_252880_(offsetVec.x(), offsetVec.y(), offsetVec.z());
        Matrix4f m = matrices.m_85850_().m_252922_();
        int blockLight = section.getWorld().m_45517_(LightLayer.BLOCK, section.getBlockPos());
        int skyLight = section.getWorld().m_45517_(LightLayer.SKY, section.getBlockPos());
        int light = LightTexture.m_109885_((int)blockLight, (int)skyLight);
        Vec2 minUv = section.getMinUv();
        Vec2 maxUv = section.getMaxUv();
        Vector3d min = new Vector3d((Vector3fc)section.getMinPos()).sub(camPos.m_7096_(), camPos.m_7098_(), camPos.m_7094_());
        float minX = (float)min.x();
        float minY = (float)min.y();
        float minZ = (float)min.z();
        Vector3d max = new Vector3d((Vector3fc)section.getMaxPos()).sub(camPos.m_7096_(), camPos.m_7098_(), camPos.m_7094_());
        float maxX = (float)max.x();
        float maxY = (float)max.y();
        float maxZ = (float)max.z();
        switch (section.getDirection()) {
            case UP: {
                SplatterEffectRenderer.vertex(buf, m, minX, minY, minZ, minUv.f_82470_, minUv.f_82471_, alpha, light);
                SplatterEffectRenderer.vertex(buf, m, maxX, minY, minZ, maxUv.f_82470_, minUv.f_82471_, alpha, light);
                SplatterEffectRenderer.vertex(buf, m, maxX, minY, maxZ, maxUv.f_82470_, maxUv.f_82471_, alpha, light);
                SplatterEffectRenderer.vertex(buf, m, minX, minY, maxZ, minUv.f_82470_, maxUv.f_82471_, alpha, light);
                break;
            }
            case DOWN: {
                SplatterEffectRenderer.vertex(buf, m, maxX, minY, minZ, maxUv.f_82470_, minUv.f_82471_, alpha, light);
                SplatterEffectRenderer.vertex(buf, m, minX, minY, minZ, minUv.f_82470_, minUv.f_82471_, alpha, light);
                SplatterEffectRenderer.vertex(buf, m, minX, minY, maxZ, minUv.f_82470_, maxUv.f_82471_, alpha, light);
                SplatterEffectRenderer.vertex(buf, m, maxX, minY, maxZ, maxUv.f_82470_, maxUv.f_82471_, alpha, light);
                break;
            }
            case NORTH: {
                SplatterEffectRenderer.vertex(buf, m, minX, minY, minZ, minUv.f_82470_, minUv.f_82471_, alpha, light);
                SplatterEffectRenderer.vertex(buf, m, minX, maxY, minZ, minUv.f_82470_, maxUv.f_82471_, alpha, light);
                SplatterEffectRenderer.vertex(buf, m, maxX, maxY, minZ, maxUv.f_82470_, maxUv.f_82471_, alpha, light);
                SplatterEffectRenderer.vertex(buf, m, maxX, minY, minZ, maxUv.f_82470_, minUv.f_82471_, alpha, light);
                break;
            }
            case EAST: {
                SplatterEffectRenderer.vertex(buf, m, maxX, minY, minZ, maxUv.f_82470_, minUv.f_82471_, alpha, light);
                SplatterEffectRenderer.vertex(buf, m, maxX, maxY, minZ, minUv.f_82470_, minUv.f_82471_, alpha, light);
                SplatterEffectRenderer.vertex(buf, m, maxX, maxY, maxZ, minUv.f_82470_, maxUv.f_82471_, alpha, light);
                SplatterEffectRenderer.vertex(buf, m, maxX, minY, maxZ, maxUv.f_82470_, maxUv.f_82471_, alpha, light);
                break;
            }
            case SOUTH: {
                SplatterEffectRenderer.vertex(buf, m, minX, minY, maxZ, minUv.f_82470_, maxUv.f_82471_, alpha, light);
                SplatterEffectRenderer.vertex(buf, m, maxX, minY, maxZ, maxUv.f_82470_, maxUv.f_82471_, alpha, light);
                SplatterEffectRenderer.vertex(buf, m, maxX, maxY, maxZ, maxUv.f_82470_, minUv.f_82471_, alpha, light);
                SplatterEffectRenderer.vertex(buf, m, minX, maxY, maxZ, minUv.f_82470_, minUv.f_82471_, alpha, light);
                break;
            }
            case WEST: {
                SplatterEffectRenderer.vertex(buf, m, minX, minY, minZ, minUv.f_82470_, minUv.f_82471_, alpha, light);
                SplatterEffectRenderer.vertex(buf, m, minX, minY, maxZ, minUv.f_82470_, maxUv.f_82471_, alpha, light);
                SplatterEffectRenderer.vertex(buf, m, minX, maxY, maxZ, maxUv.f_82470_, maxUv.f_82471_, alpha, light);
                SplatterEffectRenderer.vertex(buf, m, minX, maxY, minZ, maxUv.f_82470_, minUv.f_82471_, alpha, light);
            }
        }
        matrices.m_85849_();
    }

    private static void vertex(BufferBuilder buf, Matrix4f matrix, float x, float y, float z, float u, float v, float alpha, int light) {
        buf.m_252986_(matrix, x, y, z).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u, v).m_85969_(light).m_5752_();
    }
}

