/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.renderer.effects;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import dev.architectury.event.events.client.ClientTickEvent;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import net.arna.jcraft.client.JCraftClient;
import net.arna.jcraft.client.util.RenderUtils;
import net.arna.jcraft.common.attack.moves.kingcrimson.PredictionMove;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class TimeErasePredictionEffectRenderer {
    private static int ticksLeft = 0;
    private static final Map<Entity, Vec3> predictions = new WeakHashMap<Entity, Vec3>();
    private static RenderTarget predictionsBuffer = Minecraft.m_91087_().m_91385_();

    public static void init() {
        ClientTickEvent.CLIENT_POST.register(client -> {
            if (ticksLeft < 0) {
                predictions.clear();
                return;
            }
            if (!Minecraft.m_91087_().m_91104_()) {
                --ticksLeft;
            }
            Map<Entity, Vec3> map = predictions;
            synchronized (map) {
                TimeErasePredictionEffectRenderer.updatePredictions();
            }
        });
        RenderSystem.recordRenderCall(() -> {
            Window window = Minecraft.m_91087_().m_91268_();
            predictionsBuffer = new TextureTarget(window.m_85441_(), window.m_85442_(), true, true);
        });
    }

    public static void startEffect(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Length must be at least 1.");
        }
        ticksLeft = length;
        Minecraft client = Minecraft.m_91087_();
        for (Entity entity : PredictionMove.getEntitiesToCatch((Level)client.f_91073_, JCraftClient.getStandEntity(), (Player)client.f_91074_)) {
            predictions.put(entity, entity.m_20182_());
        }
    }

    public static void stopEffect() {
        ticksLeft = -1;
        predictions.clear();
    }

    public static void render(PoseStack stack, Vec3 camPos, ClientLevel world, float tickDelta, MultiBufferSource pConsumers) {
        if (ticksLeft < 0) {
            if (ticksLeft == -1) {
                predictionsBuffer.m_83954_(false);
                --ticksLeft;
            }
            return;
        }
        MultiBufferSource.BufferSource consumers = (MultiBufferSource.BufferSource)Objects.requireNonNull(pConsumers);
        consumers.m_109912_(Sheets.m_110789_());
        consumers.m_109912_(Sheets.m_110790_());
        predictionsBuffer.m_83954_(false);
        predictionsBuffer.m_83947_(true);
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        for (Map.Entry<Entity, Vec3> prediction : predictions.entrySet()) {
            Entity entity = prediction.getKey();
            if (entity == null || !entity.m_6084_()) continue;
            Vec3 pos = prediction.getValue().m_82546_(camPos);
            BlockPos bPos = BlockPos.m_274446_((Position)((Position)prediction.getValue()));
            int blockLight = Math.max(entity.m_6060_() ? 15 : entity.m_9236_().m_45517_(LightLayer.BLOCK, bPos), 7);
            int skyLight = Math.max(entity.m_9236_().m_45517_(LightLayer.SKY, bPos), 7);
            entityRenderDispatcher.m_114384_(entity, pos.f_82479_, pos.f_82480_ - 0.1, pos.f_82481_, entity.m_146908_(), tickDelta, stack, (MultiBufferSource)consumers, LightTexture.m_109885_((int)blockLight, (int)skyLight));
        }
        consumers.m_173043_();
        consumers.m_109912_(RenderType.m_110446_((ResourceLocation)TextureAtlas.f_118259_));
        consumers.m_109912_(RenderType.m_110452_((ResourceLocation)TextureAtlas.f_118259_));
        consumers.m_109912_(RenderType.m_110458_((ResourceLocation)TextureAtlas.f_118259_));
        consumers.m_109912_(RenderType.m_110476_((ResourceLocation)TextureAtlas.f_118259_));
        consumers.m_109912_(Sheets.m_110789_());
        consumers.m_109912_(Sheets.m_110790_());
        Minecraft.m_91087_().m_91385_().m_83947_(true);
        Window window = Minecraft.m_91087_().m_91268_();
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.setShaderTexture((int)0, (int)predictionsBuffer.m_83975_());
        RenderUtils.startOverlayRender();
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder buffer = tess.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        Matrix4f projMatrix = RenderSystem.getProjectionMatrix();
        VertexSorting vSort = RenderSystem.getVertexSorting();
        Matrix4f flatProjMatrix = new Matrix4f().setOrtho(0.0f, (float)window.m_85441_(), 0.0f, (float)window.m_85442_(), 1000.0f, 20000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)flatProjMatrix, (VertexSorting)VertexSorting.f_276633_);
        float r = 1.0f;
        float g = 0.0f;
        float b = 0.0f;
        float a = 0.33f;
        double width = window.m_85441_();
        double height = window.m_85442_();
        buffer.m_5483_(0.0, 0.0, 0.0).m_85950_(1.0f, 0.0f, 0.0f, 0.33f).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_5483_(width, 0.0, 0.0).m_85950_(1.0f, 0.0f, 0.0f, 0.33f).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_5483_(width, height, 0.0).m_85950_(1.0f, 0.0f, 0.0f, 0.33f).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_5483_(0.0, height, 0.0).m_85950_(1.0f, 0.0f, 0.0f, 0.33f).m_7421_(0.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        RenderSystem.setProjectionMatrix((Matrix4f)projMatrix, (VertexSorting)vSort);
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        RenderUtils.endOverlayRender();
    }

    private static void updatePredictions() {
        PredictionMove.updatePredictions(predictions, ticksLeft);
    }
}

