/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.renderer.entity;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.arna.jcraft.client.rendering.CloneSkinTracker;
import net.arna.jcraft.client.util.PlayerCloneClientPlayerEntity;
import net.arna.jcraft.common.entity.PlayerCloneEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;

public class PlayerCloneRenderer
extends HumanoidMobRenderer<PlayerCloneEntity, HumanoidModel<PlayerCloneEntity>> {
    private final PlayerRenderer parent;

    public PlayerCloneRenderer(EntityRendererProvider.Context ctx, boolean slim) {
        super(ctx, (HumanoidModel)new PlayerModel(ctx.m_174023_(slim ? ModelLayers.f_171166_ : ModelLayers.f_171162_), slim), 0.5f);
        this.parent = new PlayerRenderer(ctx, slim);
    }

    public boolean shouldRender(PlayerCloneEntity clone, Frustum frustum, double d, double e, double f) {
        boolean s = super.m_5523_((Mob)clone, frustum, d, e, f);
        if (clone.shouldRenderForMaster()) {
            return s;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            UUID masterId = clone.getMasterId();
            if (masterId == null) {
                return s;
            }
            return !masterId.equals(player.m_20148_());
        }
        return s;
    }

    public void render(PlayerCloneEntity clone, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        PlayerCloneClientPlayerEntity clonePlayer = CloneSkinTracker.toPlayer(clone);
        if (clonePlayer == null) {
            return;
        }
        this.parent.m_7392_((AbstractClientPlayer)clonePlayer, f, g, matrixStack, vertexConsumerProvider, i);
    }

    public ResourceLocation getTextureLocation(PlayerCloneEntity entity) {
        return CloneSkinTracker.getSkinFor(entity, MinecraftProfileTexture.Type.SKIN);
    }
}

