/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.renderer.entity.stands;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mod.azure.azurelib.cache.object.BakedGeoModel;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.client.model.entity.stand.StandEntityModel;
import net.arna.jcraft.client.renderer.entity.stands.StandEntityRenderer;
import net.arna.jcraft.common.entity.stand.CMoonEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class CMoonRenderer
extends StandEntityRenderer<CMoonEntity> {
    private int currentTick = -1;
    private static final ParticleOptions chargeParticle = new DustParticleOptions(new Vector3f(0.8f, 0.2f, 1.0f), 2.0f);

    public CMoonRenderer(EntityRendererProvider.Context context) {
        super(context, new StandEntityModel((StandType)JStandTypeRegistry.C_MOON.get()));
    }

    @Override
    public void actuallyRender(PoseStack poseStack, CMoonEntity stand, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.actuallyRender(poseStack, (CMoonEntity)this.animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, CMoonRenderer.getAlpha((StandEntity)this.animatable, partialTick));
        if (stand.getState() == CMoonEntity.State.GRAV_PUNCH && stand.getCurrentMove() != null && stand.getMoveStun() > stand.getCurrentMove().getWindupPoint() && (this.currentTick < 0 || this.currentTick != stand.f_19797_)) {
            this.currentTick = stand.f_19797_;
            model.getBone("rightLower").ifPresent(bone -> {
                RandomSource random = stand.m_217043_();
                Vector3d localPos = bone.getLocalPosition();
                Vec3 worldPos = RotationUtil.vecWorldToPlayer(localPos.x, localPos.y, localPos.z, GravityChangerAPI.getGravityDirection(this.animatable)).m_82549_(((CMoonEntity)this.animatable).m_20182_());
                Vec3 standVel = JUtils.deltaPos((Entity)stand);
                stand.m_20193_().m_7106_(chargeParticle, worldPos.f_82479_, worldPos.f_82480_, worldPos.f_82481_, standVel.f_82479_ + random.m_188583_() * 0.3, standVel.f_82480_ + random.m_188583_() * 0.3, standVel.f_82481_ + random.m_188583_() * 0.3);
            });
        }
    }
}

