/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.renderer.entity.stands;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mod.azure.azurelib.cache.object.BakedGeoModel;
import mod.azure.azurelib.renderer.GeoRenderer;
import net.arna.jcraft.client.model.entity.stand.CreamModel;
import net.arna.jcraft.client.renderer.entity.layer.CreamVoidLayer;
import net.arna.jcraft.client.renderer.entity.stands.StandEntityRenderer;
import net.arna.jcraft.common.entity.stand.CreamEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class CreamRenderer
extends StandEntityRenderer<CreamEntity> {
    public CreamRenderer(EntityRendererProvider.Context context) {
        super(context, new CreamModel());
        this.addRenderLayer(new CreamVoidLayer((GeoRenderer<CreamEntity>)this));
    }

    @Override
    public RenderType getRenderType(CreamEntity animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return animatable.getVoidTime() > 0 ? RenderType.m_110446_((ResourceLocation)texture) : super.getRenderType(animatable, texture, bufferSource, partialTick);
    }

    @Override
    protected float getRed(CreamEntity stand, float red, float alpha) {
        return red - (1.0f - alpha) / 2.0f;
    }

    @Override
    protected float getGreen(CreamEntity stand, float green, float alpha) {
        return green - (1.0f - alpha) / 2.0f;
    }

    @Override
    public void actuallyRender(PoseStack poseStack, CreamEntity animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        float a = StandEntityRenderer.getAlpha(animatable, partialTick);
        if (a < 0.01f) {
            return;
        }
        super.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, a);
    }
}

