/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.renderer.entity.stands;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import mod.azure.azurelib.cache.object.BakedGeoModel;
import mod.azure.azurelib.cache.object.GeoBone;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.renderer.GeoRenderer;
import mod.azure.azurelib.renderer.layer.BlockAndItemGeoLayer;
import mod.azure.azurelib.renderer.layer.GeoRenderLayer;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.client.model.entity.stand.StandEntityModel;
import net.arna.jcraft.client.renderer.entity.stands.StandEntityRenderer;
import net.arna.jcraft.common.entity.stand.D4CEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;

public class D4CRenderer
extends StandEntityRenderer<D4CEntity> {
    protected float partialTick = 0.0f;

    public D4CRenderer(EntityRendererProvider.Context context) {
        super(context, new StandEntityModel((StandType)JStandTypeRegistry.D4C.get()));
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<D4CEntity>((GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, D4CEntity animatable) {
                return switch (bone.getName()) {
                    case "bipedHandLeft" -> {
                        if (animatable.m_21526_()) {
                            yield D4CRenderer.this.mainHandItem;
                        }
                        yield D4CRenderer.this.offHandItem;
                    }
                    case "bipedHandRight" -> {
                        if (animatable.m_21526_()) {
                            yield D4CRenderer.this.offHandItem;
                        }
                        yield D4CRenderer.this.mainHandItem;
                    }
                    default -> null;
                };
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, D4CEntity animatable) {
                return switch (bone.getName()) {
                    case "bipedHandLeft", "bipedHandRight" -> ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, D4CEntity animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(bone.getRotX() * 57.29578f));
                if (stack == D4CRenderer.this.mainHandItem) {
                    if (stack.m_41720_() instanceof ShieldItem) {
                        poseStack.m_85837_(0.0, 0.125, -0.25);
                    }
                } else if (stack == D4CRenderer.this.offHandItem && stack.m_41720_() instanceof ShieldItem) {
                    poseStack.m_85837_(0.0, 0.125, 0.25);
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                }
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    @Override
    public void actuallyRender(PoseStack poseStack, D4CEntity animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        float a = StandEntityRenderer.getAlpha(animatable, partialTick);
        float gR = 1.0f - a;
        this.mainHandItem = animatable.m_21205_();
        this.offHandItem = animatable.m_21206_();
        super.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green - gR, blue, a);
    }
}

