/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.renderer.entity.stands;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import mod.azure.azurelib.cache.object.BakedGeoModel;
import mod.azure.azurelib.util.RenderUtils;
import net.arna.jcraft.client.model.entity.stand.MetallicaModel;
import net.arna.jcraft.client.renderer.entity.stands.StandEntityRenderer;
import net.arna.jcraft.common.entity.stand.MetallicaEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;

public class MetallicaRenderer
extends StandEntityRenderer<MetallicaEntity> {
    private final ItemInHandRenderer heldItemRenderer;
    private static final ItemStack IRON_NUGGET = Items.f_42749_.m_7968_();

    public MetallicaRenderer(EntityRendererProvider.Context context) {
        super(context, new MetallicaModel());
        this.heldItemRenderer = context.m_234598_();
    }

    @Override
    public void actuallyRender(PoseStack matrixStack, MetallicaEntity animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        float a = StandEntityRenderer.getAlpha(animatable, partialTick);
        super.actuallyRender(matrixStack, animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, a);
        if (!animatable.hasUser()) {
            return;
        }
        if (animatable.getState() == MetallicaEntity.State.HARVEST) {
            BlockPos siphonPos = animatable.getSiphonPos().orElse(null);
            if (siphonPos == null) {
                return;
            }
            LivingEntity user = animatable.getUserOrThrow();
            Vec3 eyeOffset = GravityChangerAPI.getEyeOffset((Entity)user).m_82490_(0.75);
            Vec3 midPos = new Vec3(Mth.m_14139_((double)partialTick, (double)user.f_19790_, (double)user.m_20185_()), Mth.m_14139_((double)partialTick, (double)user.f_19791_, (double)user.m_20186_()), Mth.m_14139_((double)partialTick, (double)user.f_19792_, (double)user.m_20189_())).m_82549_(GravityChangerAPI.getEyeOffset((Entity)user));
            Vec3 toUser = siphonPos.m_252807_().m_82546_(midPos).m_82490_(0.2);
            Vec3 standToUser = user.m_20182_().m_82546_(animatable.m_20182_()).m_82549_(eyeOffset);
            double time = RenderUtils.getCurrentTick() / 5.0 % 1.0;
            matrixStack.m_85836_();
            matrixStack.m_85837_(standToUser.f_82479_, standToUser.f_82480_, standToUser.f_82481_);
            matrixStack.m_85837_(-toUser.f_82479_ * time, -toUser.f_82480_ * time, -toUser.f_82481_ * time);
            for (int i = 0; i < 5; ++i) {
                matrixStack.m_85837_(toUser.f_82479_, toUser.f_82480_, toUser.f_82481_);
                matrixStack.m_85836_();
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14179_((float)partialTick, (float)user.f_19860_, (float)user.m_146909_())));
                matrixStack.m_252781_(Axis.f_252392_.m_252977_(Mth.m_14179_((float)partialTick, (float)user.f_19859_, (float)user.m_146908_()) + 90.0f));
                this.heldItemRenderer.m_269530_((LivingEntity)animatable, IRON_NUGGET, ItemDisplayContext.GROUND, false, matrixStack, bufferSource, packedLight);
                matrixStack.m_85849_();
            }
            matrixStack.m_85849_();
        }
    }
}

