/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.renderer.entity.stands;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mod.azure.azurelib.cache.object.BakedGeoModel;
import mod.azure.azurelib.cache.object.GeoBone;
import mod.azure.azurelib.constant.DataTickets;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.model.data.EntityModelData;
import mod.azure.azurelib.renderer.GeoEntityRenderer;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.client.JClientConfig;
import net.arna.jcraft.client.model.entity.stand.StandEntityModel;
import net.arna.jcraft.client.util.JClientUtils;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class StandEntityRenderer<T extends StandEntity<?, ?>>
extends GeoEntityRenderer<T> {
    protected ItemStack mainHandItem;
    protected ItemStack offHandItem;
    protected static final String LEFT_HAND = "bipedHandLeft";
    protected static final String RIGHT_HAND = "bipedHandRight";

    protected StandEntityRenderer(EntityRendererProvider.Context renderManager, StandEntityModel<T> modelProvider) {
        super(renderManager, modelProvider);
    }

    public ResourceLocation getTextureLocation(T animatable) {
        return this.getGeoModel().getTextureResource(animatable);
    }

    public static boolean standIsFirstPersonViewers(StandEntity<?, ?> stand) {
        Minecraft mcClient = Minecraft.m_91087_();
        return mcClient.f_91066_.m_92176_().m_90612_() && mcClient.f_91074_ != null && JUtils.getStand((LivingEntity)mcClient.f_91074_) == stand;
    }

    public static RenderType renderTypeOf(StandEntity<?, ?> stand, ResourceLocation textureLocation) {
        return StandEntityRenderer.standIsFirstPersonViewers(stand) ? RenderType.m_110482_((ResourceLocation)textureLocation) : RenderType.m_110473_((ResourceLocation)textureLocation);
    }

    public RenderType getRenderType(T animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return StandEntityRenderer.renderTypeOf(animatable, texture);
    }

    public void preRender(PoseStack poseStack, T stand, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        float a = StandEntityRenderer.getAlpha(stand, partialTick);
        if ((a *= alpha) <= 0.01f) {
            return;
        }
        super.preRender(poseStack, stand, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, this.getRed(stand, red, a), this.getGreen(stand, green, a), this.getBlue(stand, blue, a), alpha);
    }

    public void actuallyRender(PoseStack poseStack, T animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        Direction bedDirection;
        Entity entity;
        if (animatable == null) {
            return;
        }
        poseStack.m_85836_();
        boolean shouldSit = animatable.m_20159_() && animatable.m_20202_() != null;
        float lerpBodyRot = Mth.m_14189_((float)partialTick, (float)((StandEntity)animatable).f_20884_, (float)((StandEntity)animatable).f_20883_);
        float lerpHeadRot = Mth.m_14189_((float)partialTick, (float)((StandEntity)animatable).f_20886_, (float)((StandEntity)animatable).f_20885_);
        float netHeadYaw = lerpHeadRot - lerpBodyRot;
        if (shouldSit && !((StandEntity)animatable).isFree() && (entity = animatable.m_20202_()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            lerpBodyRot = Mth.m_14189_((float)partialTick, (float)livingentity.f_20886_, (float)livingentity.f_20885_);
            netHeadYaw = lerpHeadRot - lerpBodyRot;
            float clampedHeadYaw = Mth.m_14036_((float)Mth.m_14177_((float)netHeadYaw), (float)-85.0f, (float)85.0f);
            lerpBodyRot = lerpHeadRot - clampedHeadYaw;
            if (clampedHeadYaw * clampedHeadYaw > 2500.0f) {
                lerpBodyRot += clampedHeadYaw * 0.2f;
            }
            netHeadYaw = lerpHeadRot - lerpBodyRot;
        }
        if (animatable.m_20089_() == Pose.SLEEPING && (bedDirection = animatable.m_21259_()) != null) {
            float eyePosOffset = animatable.m_20236_(Pose.STANDING) - 0.1f;
            poseStack.m_252880_((float)(-bedDirection.m_122429_()) * eyePosOffset, 0.0f, (float)(-bedDirection.m_122431_()) * eyePosOffset);
        }
        float ageInTicks = (float)((StandEntity)animatable).f_19797_ + partialTick;
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        this.applyRotations((Entity)animatable, poseStack, ageInTicks, lerpBodyRot, partialTick);
        if (!shouldSit && animatable.m_6084_()) {
            limbSwingAmount = ((StandEntity)animatable).f_267362_.m_267711_(partialTick);
            limbSwing = ((StandEntity)animatable).f_267362_.m_267590_(partialTick);
            if (animatable.m_6162_()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        if (!isReRender) {
            float headPitch = Mth.m_14179_((float)partialTick, (float)((StandEntity)animatable).f_19860_, (float)animatable.m_146909_());
            float motionThreshold = this.getMotionAnimThreshold((GeoAnimatable)animatable);
            Vec3 velocity = animatable.m_20184_();
            float avgVelocity = (float)(Math.abs(velocity.f_82479_) + Math.abs(velocity.f_82481_) / 2.0);
            AnimationState animationState = new AnimationState(animatable, limbSwing, limbSwingAmount, partialTick, avgVelocity >= motionThreshold && limbSwingAmount != 0.0f);
            long instanceId = this.getInstanceId((Entity)animatable);
            animationState.setData(DataTickets.TICK, (Object)animatable.getTick(animatable));
            animationState.setData(DataTickets.ENTITY, animatable);
            EntityModelData data = new EntityModelData(shouldSit, animatable.m_6162_(), -netHeadYaw, -headPitch);
            animationState.setData(DataTickets.ENTITY_MODEL_DATA, (Object)data);
            this.model.addAdditionalStateData(animatable, instanceId, (arg_0, arg_1) -> ((AnimationState)animationState).setData(arg_0, arg_1));
            this.model.handleAnimations(animatable, instanceId, animationState);
        }
        poseStack.m_252880_(0.0f, 0.01f, 0.0f);
        this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        if (animatable.m_20177_((Player)Minecraft.m_91087_().f_91074_)) {
            if (Minecraft.m_91087_().m_91314_(animatable)) {
                renderType = RenderType.m_110491_((ResourceLocation)this.getTextureLocation(animatable));
                buffer = bufferSource.m_6299_(renderType);
            } else {
                renderType = null;
            }
        }
        if (renderType != null) {
            this.updateAnimatedTextureFrame((Entity)animatable);
            for (GeoBone group : model.topLevelBones()) {
                this.renderRecursively(poseStack, (Entity)animatable, group, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
            }
        }
        poseStack.m_85849_();
    }

    protected int getBlockLightLevel(T stand, BlockPos pos) {
        if (!((StandEntity)stand).hasUser()) {
            return super.m_6086_(stand, pos);
        }
        if (stand.m_6060_() || ((StandEntity)stand).getUserOrThrow().m_6060_()) {
            return 15;
        }
        return stand.m_9236_().m_45517_(LightLayer.BLOCK, ((StandEntity)stand).getUserOrThrow().m_20183_());
    }

    protected int getSkyLightLevel(T stand, BlockPos pos) {
        return ((StandEntity)stand).hasUser() ? stand.m_9236_().m_45517_(LightLayer.SKY, ((StandEntity)stand).getUserOrThrow().m_20183_()) : super.m_114508_(stand, pos);
    }

    public boolean firePreRenderEvent(PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
        if (!JClientUtils.shouldRenderStands()) {
            return false;
        }
        return super.firePreRenderEvent(poseStack, model, bufferSource, partialTick, packedLight);
    }

    public static boolean shouldApplyAlpha(StandEntity<?, ?> stand) {
        Minecraft mcClient = Minecraft.m_91087_();
        return mcClient.f_91074_ != null && mcClient.f_91066_.m_92176_().m_90612_() && JUtils.getStand((LivingEntity)mcClient.f_91074_) == stand;
    }

    public static float getAlpha(StandEntity<?, ?> stand, float tickDelta) {
        float a;
        if (!StandEntityRenderer.shouldApplyAlpha(stand)) {
            return 1.0f;
        }
        if (stand.hasAlphaOverride() && stand.getPrevAlpha() >= 0.0f) {
            return stand.getAlphaOverride();
        }
        JClientConfig config = JClientConfig.getInstance();
        float alphaMult = config.getFirstPersonStandOpacityMult();
        float f = a = config.isDynamicFirstPersonStandOpacity() ? alphaMult * Mth.m_14036_((float)((float)stand.m_20280_((Entity)Minecraft.m_91087_().f_91074_) / 2.0f), (float)0.0f, (float)1.0f) : alphaMult;
        if (!stand.hasAlphaOverride()) {
            return a;
        }
        return Mth.m_14179_((float)tickDelta, (float)a, (float)stand.getAlphaOverride());
    }

    protected float getRed(T stand, float red, float alpha) {
        return red;
    }

    protected float getGreen(T stand, float green, float alpha) {
        return green;
    }

    protected float getBlue(T stand, float blue, float alpha) {
        return blue;
    }
}

