/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.renderer.entity.stands;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import mod.azure.azurelib.cache.object.BakedGeoModel;
import mod.azure.azurelib.cache.object.GeoBone;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.renderer.GeoRenderer;
import mod.azure.azurelib.renderer.layer.BlockAndItemGeoLayer;
import mod.azure.azurelib.renderer.layer.GeoRenderLayer;
import net.arna.jcraft.client.model.entity.stand.WhiteSnakeModel;
import net.arna.jcraft.client.renderer.entity.stands.StandEntityRenderer;
import net.arna.jcraft.common.entity.stand.WhiteSnakeEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import org.jetbrains.annotations.Nullable;

public class WhiteSnakeRenderer
extends StandEntityRenderer<WhiteSnakeEntity> {
    public WhiteSnakeRenderer(EntityRendererProvider.Context context) {
        super(context, new WhiteSnakeModel());
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<WhiteSnakeEntity>((GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, WhiteSnakeEntity animatable) {
                return switch (bone.getName()) {
                    case "bipedHandLeft" -> {
                        if (animatable.m_21526_()) {
                            yield WhiteSnakeRenderer.this.mainHandItem;
                        }
                        yield WhiteSnakeRenderer.this.offHandItem;
                    }
                    case "bipedHandRight" -> {
                        if (animatable.m_21526_()) {
                            yield WhiteSnakeRenderer.this.offHandItem;
                        }
                        yield WhiteSnakeRenderer.this.mainHandItem;
                    }
                    default -> null;
                };
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, WhiteSnakeEntity animatable) {
                return switch (bone.getName()) {
                    case "bipedHandLeft" -> ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
                    case "bipedHandRight" -> ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, WhiteSnakeEntity animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(bone.getRotX() - 90.0f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(bone.getRotZ() - 90.0f));
                if (stack == WhiteSnakeRenderer.this.mainHandItem) {
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                    if (stack.m_41720_() instanceof ShieldItem) {
                        poseStack.m_85837_(0.0, 0.125, -0.25);
                    }
                } else if (stack == WhiteSnakeRenderer.this.offHandItem) {
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                    if (stack.m_41720_() instanceof ShieldItem) {
                        poseStack.m_85837_(0.0, 0.125, 0.25);
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    }
                }
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    @Override
    public RenderType getRenderType(WhiteSnakeEntity animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return StandEntityRenderer.renderTypeOf(animatable, texture);
    }

    @Override
    public void actuallyRender(PoseStack poseStack, WhiteSnakeEntity animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        float a = StandEntityRenderer.getAlpha(animatable, partialTick);
        this.mainHandItem = animatable.m_21205_();
        this.offHandItem = animatable.m_21206_();
        super.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, a);
    }
}

