/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.renderer.features;

import com.google.common.collect.Streams;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.stream.Stream;
import net.arna.jcraft.common.entity.projectile.KnifeProjectile;
import net.arna.jcraft.mixin.client.AnimalModelAccessor;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class StuckKnivesFeatureRenderer<T extends LivingEntity, M extends AgeableListModel<T>>
extends RenderLayer<T, M> {
    private final EntityRenderDispatcher dispatcher;

    public StuckKnivesFeatureRenderer(EntityRendererProvider.Context context, LivingEntityRenderer<T, M> entityRenderer) {
        super(entityRenderer);
        this.dispatcher = context.m_174022_();
    }

    protected int getObjectCount(T entity) {
        return JComponentPlatformUtils.getMiscData(entity).getStuckKnifeCount();
    }

    protected void renderObject(PoseStack matrices, MultiBufferSource vertexConsumers, int light, Entity entity, float directionX, float directionY, float directionZ, float tickDelta) {
        float f = Mth.m_14116_((float)(directionX * directionX + directionZ * directionZ));
        KnifeProjectile knife = new KnifeProjectile(entity.m_9236_());
        knife.m_20343_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        knife.m_146922_((float)(Math.atan2(directionX, directionZ) * 57.2957763671875));
        knife.m_146926_((float)(Math.atan2(directionY, f) * 57.2957763671875));
        knife.f_19859_ = knife.m_146908_();
        knife.f_19860_ = knife.m_146909_();
        this.dispatcher.m_114384_((Entity)knife, 0.0, 0.0, 0.0, 0.0f, tickDelta, matrices, vertexConsumers, light);
    }

    public void render(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, T livingEntity, float f, float g, float h, float j, float k, float l) {
        int m = this.getObjectCount(livingEntity);
        RandomSource random = RandomSource.m_216335_((long)livingEntity.m_19879_());
        if (m <= 0) {
            return;
        }
        for (int n = 0; n < m; ++n) {
            matrixStack.m_85836_();
            AnimalModelAccessor accessor = (AnimalModelAccessor)this.m_117386_();
            List parts = Stream.concat(Streams.stream(accessor.callHeadParts()), Streams.stream(accessor.callBodyParts())).toList();
            ModelPart part = (ModelPart)parts.get(random.m_188503_(parts.size()));
            if (!part.m_171326_()) {
                ModelPart.Cube cuboid = part.m_233558_(random);
                part.m_104299_(matrixStack);
                float o = random.m_188501_();
                float p = random.m_188501_();
                float q = random.m_188501_();
                float r = Mth.m_14179_((float)o, (float)cuboid.f_104335_, (float)cuboid.f_104338_) / 16.0f;
                float s = Mth.m_14179_((float)p, (float)cuboid.f_104336_, (float)cuboid.f_104339_) / 16.0f;
                float t = Mth.m_14179_((float)q, (float)cuboid.f_104337_, (float)cuboid.f_104340_) / 16.0f;
                matrixStack.m_252880_(r, s, t);
                o = -1.0f * (o * 2.0f - 1.0f);
                p = -1.0f * (p * 2.0f - 1.0f);
                q = -1.0f * (q * 2.0f - 1.0f);
                this.renderObject(matrixStack, vertexConsumerProvider, i, (Entity)livingEntity, o, p, q, h);
            }
            matrixStack.m_85849_();
        }
    }
}

