/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.rendering;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.arna.jcraft.client.util.PlayerCloneClientPlayerEntity;
import net.arna.jcraft.common.entity.PlayerCloneEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;

public final class CloneSkinTracker {
    private static final Map<PlayerCloneEntity, Map<MinecraftProfileTexture.Type, ResourceLocation>> skinCache = new WeakHashMap<PlayerCloneEntity, Map<MinecraftProfileTexture.Type, ResourceLocation>>();
    private static final Map<PlayerCloneEntity, String> modelCache = new WeakHashMap<PlayerCloneEntity, String>();
    private static final Map<PlayerCloneEntity, PlayerCloneClientPlayerEntity> playerCache = new WeakHashMap<PlayerCloneEntity, PlayerCloneClientPlayerEntity>();
    private static final Set<PlayerCloneEntity> loading = Collections.newSetFromMap(new WeakHashMap());

    public static ResourceLocation getSkinFor(PlayerCloneEntity clone, MinecraftProfileTexture.Type type) {
        ResourceLocation skin;
        if (!skinCache.containsKey(clone)) {
            CloneSkinTracker.load(clone);
        }
        return (skin = (ResourceLocation)skinCache.getOrDefault(clone, Collections.emptyMap()).get(type)) == null && type == MinecraftProfileTexture.Type.SKIN ? DefaultPlayerSkin.m_118627_((UUID)clone.getMasterId()) : skin;
    }

    public static String getModelFor(PlayerCloneEntity clone) {
        if (!skinCache.containsKey(clone)) {
            CloneSkinTracker.load(clone);
        }
        return modelCache.getOrDefault(clone, clone.getMasterId() == null ? "default" : DefaultPlayerSkin.m_118629_((UUID)clone.getMasterId()));
    }

    public static PlayerCloneClientPlayerEntity toPlayer(PlayerCloneEntity clone) {
        if (clone.getGameProfile() == null) {
            return null;
        }
        PlayerCloneClientPlayerEntity clonePlayer = playerCache.computeIfAbsent(clone, PlayerCloneClientPlayerEntity::new);
        clonePlayer.updateData();
        return clonePlayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(PlayerCloneEntity clone) {
        GameProfile profile = clone.getGameProfile();
        if (profile == null) {
            return;
        }
        Set<PlayerCloneEntity> set = loading;
        synchronized (set) {
            if (loading.contains(clone)) {
                return;
            }
            loading.add(clone);
        }
        Minecraft.m_91087_().m_91109_().m_118817_(profile, (type, id, texture) -> {
            String model;
            skinCache.computeIfAbsent(clone, c -> new HashMap()).put(type, id);
            Set<PlayerCloneEntity> set = loading;
            synchronized (set) {
                loading.remove(clone);
            }
            if (type != MinecraftProfileTexture.Type.SKIN || (model = texture.getMetadata("model")) == null) {
                return;
            }
            modelCache.put(clone, model);
        }, true);
    }

    private CloneSkinTracker() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

