/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.rendering;

import java.util.Map;
import java.util.WeakHashMap;
import net.arna.jcraft.common.entity.TrainingDummyEntity;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public final class DamageIndicatorManager {
    private static final Map<TrainingDummyEntity, Integer> dummyPositionCounter = new WeakHashMap<TrainingDummyEntity, Integer>();
    private static SimpleParticleType DAMAGE_NUMBER_PARTICLE;

    public static void setDamageNumberParticle(SimpleParticleType particle) {
        DAMAGE_NUMBER_PARTICLE = particle;
    }

    public static void spawnDamageNumber(Entity entity, float damageAmount) {
        if (DAMAGE_NUMBER_PARTICLE == null || !entity.m_9236_().f_46443_) {
            return;
        }
        Level level = entity.m_9236_();
        int animationPos = 0;
        if (entity instanceof TrainingDummyEntity) {
            TrainingDummyEntity dummy = (TrainingDummyEntity)entity;
            animationPos = DamageIndicatorManager.getNextNumberPos(dummy);
        }
        double x = entity.m_20185_();
        double y = entity.m_20186_() + (double)entity.m_20206_() * 0.4;
        double z = entity.m_20189_();
        level.m_7106_((ParticleOptions)DAMAGE_NUMBER_PARTICLE, x, y, z, (double)damageAmount, 0.0, (double)animationPos);
    }

    private static int getNextNumberPos(TrainingDummyEntity dummy) {
        Integer current = dummyPositionCounter.get(dummy);
        if (current == null) {
            current = 0;
        }
        current = (current + 1) % 5;
        dummyPositionCounter.put(dummy, current);
        return current;
    }

    private DamageIndicatorManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

