/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.rendering;

import net.minecraft.Util;

public class FrameCounter {
    private final long singleFrameTime;
    private final int frameCount;
    private final boolean shouldLoop;
    private long start;
    private long offset;
    private boolean paused;

    public FrameCounter(float framerate, int frameCount, boolean shouldLoop) {
        this.singleFrameTime = (long)(1.0E9f / framerate);
        this.frameCount = frameCount;
        this.shouldLoop = shouldLoop;
    }

    public void start() {
        this.start = Util.m_137569_();
        this.offset = 0L;
        this.paused = false;
    }

    public void pause() {
        if (this.paused) {
            return;
        }
        this.offset += Util.m_137569_() - this.start;
        this.paused = true;
    }

    public void unpause() {
        if (!this.paused) {
            return;
        }
        this.start = Util.m_137569_();
        this.paused = false;
    }

    public int getCurrentFrame() {
        long d = (this.paused ? 0L : Util.m_137569_() - this.start) + this.offset;
        int frame = (int)(d / this.singleFrameTime);
        return !this.shouldLoop && frame >= this.frameCount ? -1 : frame % this.frameCount;
    }

    public long getSingleFrameTime() {
        return this.singleFrameTime;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public boolean isShouldLoop() {
        return this.shouldLoop;
    }

    public boolean isPaused() {
        return this.paused;
    }
}

