/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.rendering;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import net.arna.jcraft.client.rendering.FrameCounter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.phys.Vec2;

public class HUDAnimation {
    private static final Pattern FILE_NAME_PATTERN = Pattern.compile("frame(\\d*)");
    private final ResourceLocation atlas;
    private final List<Frame> frames;
    private final AtomicReference<Object> frameCount = new AtomicReference();

    public static HUDAnimation create(ResourceLocation atlas, ResourceLocation atlasData) {
        JsonObject data;
        Optional dataRes = Minecraft.m_91087_().m_91098_().m_213713_(atlasData);
        if (dataRes.isEmpty()) {
            throw new IllegalArgumentException("Atlas data not found.");
        }
        try (BufferedReader reader = ((Resource)dataRes.get()).m_215508_();){
            data = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read atlas data.");
        }
        JsonArray framesData = data.getAsJsonArray("frames");
        JsonObject sizeData = data.getAsJsonObject("meta").getAsJsonObject("size");
        int atlasWidth = sizeData.get("w").getAsInt();
        int atlasHeight = sizeData.get("h").getAsInt();
        List<Frame> frames = StreamSupport.stream(framesData.spliterator(), false).peek(HUDAnimation::validateFrame).map(frame -> Frame.parse(frame.getAsJsonObject(), atlas, atlasWidth, atlasHeight)).sorted(Comparator.comparingInt(Frame::getIndex)).toList();
        return new HUDAnimation(atlas, frames);
    }

    private static void validateFrame(JsonElement frame) {
        if (!frame.isJsonObject()) {
            throw new IllegalArgumentException("Frame in atlas data is not an object");
        }
        JsonObject frameObj = frame.getAsJsonObject();
        if (!FILE_NAME_PATTERN.asMatchPredicate().test(frameObj.get("filename").getAsString())) {
            throw new IllegalArgumentException("Frame in atlas data has invalid filename (must be of format 'frame<i>' where <i> is a 1-based index.");
        }
        if (frameObj.get("rotated").getAsBoolean()) {
            throw new IllegalArgumentException("Frames may not be rotated");
        }
        if (frameObj.get("trimmed").getAsBoolean()) {
            throw new IllegalArgumentException("Frames may not be trimmed");
        }
    }

    public void preload(TextureManager textureManager, Executor executor) {
        textureManager.m_118501_(this.getAtlas(), executor);
    }

    public Frame getFrame(int i) {
        return this.frames.get(i);
    }

    public FrameCounter createFrameCounter(float framerate, boolean shouldLoop) {
        return new FrameCounter(framerate, this.getFrameCount(), shouldLoop);
    }

    public ResourceLocation getAtlas() {
        return this.atlas;
    }

    public List<Frame> getFrames() {
        return this.frames;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HUDAnimation)) {
            return false;
        }
        HUDAnimation other = (HUDAnimation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFrameCount() != other.getFrameCount()) {
            return false;
        }
        ResourceLocation this$atlas = this.getAtlas();
        ResourceLocation other$atlas = other.getAtlas();
        if (this$atlas == null ? other$atlas != null : !this$atlas.equals(other$atlas)) {
            return false;
        }
        List<Frame> this$frames = this.getFrames();
        List<Frame> other$frames = other.getFrames();
        return !(this$frames == null ? other$frames != null : !((Object)this$frames).equals(other$frames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HUDAnimation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFrameCount();
        ResourceLocation $atlas = this.getAtlas();
        result = result * 59 + ($atlas == null ? 43 : $atlas.hashCode());
        List<Frame> $frames = this.getFrames();
        result = result * 59 + ($frames == null ? 43 : ((Object)$frames).hashCode());
        return result;
    }

    public String toString() {
        return "HUDAnimation(atlas=" + String.valueOf(this.getAtlas()) + ", frames=" + String.valueOf(this.getFrames()) + ", frameCount=" + this.getFrameCount() + ")";
    }

    private HUDAnimation(ResourceLocation atlas, List<Frame> frames) {
        this.atlas = atlas;
        this.frames = frames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFrameCount() {
        Object $value = this.frameCount.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.frameCount;
            synchronized (atomicReference) {
                $value = this.frameCount.get();
                if ($value == null) {
                    int actualValue = this.frames.size();
                    $value = actualValue;
                    this.frameCount.set($value);
                }
            }
        }
        return (Integer)$value;
    }

    public static class Frame {
        private final ResourceLocation atlas;
        private final int index;
        private final int width;
        private final int height;
        private final int xOffset;
        private final int yOffset;
        private final Vec2 uvMin;
        private final Vec2 uvMax;

        private static Frame parse(JsonObject frame, ResourceLocation atlas, int atlasWidth, int atlasHeight) {
            JsonObject frameData = frame.getAsJsonObject("frame");
            int index = Integer.parseInt(frame.get("filename").getAsString().substring(5));
            int width = frameData.get("w").getAsInt();
            int height = frameData.get("h").getAsInt();
            int xOffset = frameData.get("x").getAsInt();
            int yOffset = frameData.get("y").getAsInt();
            float uMin = (float)xOffset / (float)atlasWidth;
            float vMin = (float)yOffset / (float)atlasHeight;
            float uMax = (float)(xOffset + width) / (float)atlasWidth;
            float vMax = (float)(yOffset + height) / (float)atlasHeight;
            return new Frame(atlas, index, width, height, xOffset, yOffset, new Vec2(uMin, vMin), new Vec2(uMax, vMax));
        }

        public void render() {
            Window window = Minecraft.m_91087_().m_91268_();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getAtlas());
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder bufferBuilder = tessellator.m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferBuilder.m_5483_(0.0, (double)window.m_85446_(), -90.0).m_7421_(this.getUvMin().f_82470_, this.getUvMax().f_82471_).m_5752_();
            bufferBuilder.m_5483_((double)window.m_85445_(), (double)window.m_85446_(), -90.0).m_7421_(this.getUvMax().f_82470_, this.getUvMax().f_82471_).m_5752_();
            bufferBuilder.m_5483_((double)window.m_85445_(), 0.0, -90.0).m_7421_(this.getUvMax().f_82470_, this.getUvMin().f_82471_).m_5752_();
            bufferBuilder.m_5483_(0.0, 0.0, -90.0).m_7421_(this.getUvMin().f_82470_, this.getUvMin().f_82471_).m_5752_();
            tessellator.m_85914_();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
        }

        public ResourceLocation getAtlas() {
            return this.atlas;
        }

        public int getIndex() {
            return this.index;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getXOffset() {
            return this.xOffset;
        }

        public int getYOffset() {
            return this.yOffset;
        }

        public Vec2 getUvMin() {
            return this.uvMin;
        }

        public Vec2 getUvMax() {
            return this.uvMax;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Frame)) {
                return false;
            }
            Frame other = (Frame)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getIndex() != other.getIndex()) {
                return false;
            }
            if (this.getWidth() != other.getWidth()) {
                return false;
            }
            if (this.getHeight() != other.getHeight()) {
                return false;
            }
            if (this.getXOffset() != other.getXOffset()) {
                return false;
            }
            if (this.getYOffset() != other.getYOffset()) {
                return false;
            }
            ResourceLocation this$atlas = this.getAtlas();
            ResourceLocation other$atlas = other.getAtlas();
            if (this$atlas == null ? other$atlas != null : !this$atlas.equals(other$atlas)) {
                return false;
            }
            Vec2 this$uvMin = this.getUvMin();
            Vec2 other$uvMin = other.getUvMin();
            if (this$uvMin == null ? other$uvMin != null : !this$uvMin.equals(other$uvMin)) {
                return false;
            }
            Vec2 this$uvMax = this.getUvMax();
            Vec2 other$uvMax = other.getUvMax();
            return !(this$uvMax == null ? other$uvMax != null : !this$uvMax.equals(other$uvMax));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Frame;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIndex();
            result = result * 59 + this.getWidth();
            result = result * 59 + this.getHeight();
            result = result * 59 + this.getXOffset();
            result = result * 59 + this.getYOffset();
            ResourceLocation $atlas = this.getAtlas();
            result = result * 59 + ($atlas == null ? 43 : $atlas.hashCode());
            Vec2 $uvMin = this.getUvMin();
            result = result * 59 + ($uvMin == null ? 43 : $uvMin.hashCode());
            Vec2 $uvMax = this.getUvMax();
            result = result * 59 + ($uvMax == null ? 43 : $uvMax.hashCode());
            return result;
        }

        public String toString() {
            return "HUDAnimation.Frame(atlas=" + String.valueOf(this.getAtlas()) + ", index=" + this.getIndex() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", xOffset=" + this.getXOffset() + ", yOffset=" + this.getYOffset() + ", uvMin=" + String.valueOf(this.getUvMin()) + ", uvMax=" + String.valueOf(this.getUvMax()) + ")";
        }

        private Frame(ResourceLocation atlas, int index, int width, int height, int xOffset, int yOffset, Vec2 uvMin, Vec2 uvMax) {
            this.atlas = atlas;
            this.index = index;
            this.width = width;
            this.height = height;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.uvMin = uvMin;
            this.uvMax = uvMax;
        }
    }
}

