/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.rendering;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import net.arna.jcraft.client.rendering.IJShader;
import net.arna.jcraft.client.rendering.shader.ShaderUniformHandler;
import net.arna.jcraft.client.util.RenderUtils;
import net.arna.jcraft.platform.JPlatformUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import org.joml.Matrix4f;

public class RenderHandler {
    public static HashMap<RenderType, BufferBuilder> BUFFERS = new HashMap();
    public static boolean LARGER_BUFFER_SOURCES = JPlatformUtils.isModLoaded("sodium");
    public static HashMap<RenderType, ShaderUniformHandler> UNIFORM_HANDLERS = new HashMap();
    public static MultiBufferSource.BufferSource DELAYED_RENDER;
    public static Matrix4f MATRIX4F;
    public static float FOG_NEAR;
    public static float FOG_FAR;
    public static FogShape FOG_SHAPE;
    public static float FOG_RED;
    public static float FOG_GREEN;
    public static float FOG_BLUE;

    public static void init() {
        int size = LARGER_BUFFER_SOURCES ? 262144 : 256;
        DELAYED_RENDER = MultiBufferSource.m_109900_(BUFFERS, (BufferBuilder)new BufferBuilder(size));
    }

    public static void cacheFogData(float near, float far, FogShape shape) {
        FOG_NEAR = near;
        FOG_FAR = far;
        FOG_SHAPE = shape;
    }

    public static void cacheFogData(float r, float g, float b) {
        FOG_RED = r;
        FOG_GREEN = g;
        FOG_BLUE = b;
    }

    public static void beginBufferedRendering(PoseStack matrixStack) {
        matrixStack.m_85836_();
        LightTexture lightTexture = Minecraft.m_91087_().f_91063_.m_109154_();
        lightTexture.m_109896_();
        RenderSystem.activeTexture((int)33986);
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        float fogRed = RenderSystem.getShaderFogColor()[0];
        float fogGreen = RenderSystem.getShaderFogColor()[1];
        float fogBlue = RenderSystem.getShaderFogColor()[2];
        float shaderFogStart = RenderSystem.getShaderFogStart();
        float shaderFogEnd = RenderSystem.getShaderFogEnd();
        FogShape shaderFogShape = RenderSystem.getShaderFogShape();
        RenderSystem.setShaderFogStart((float)FOG_NEAR);
        RenderSystem.setShaderFogEnd((float)FOG_FAR);
        RenderSystem.setShaderFogShape((FogShape)FOG_SHAPE);
        RenderSystem.setShaderFogColor((float)FOG_RED, (float)FOG_GREEN, (float)FOG_BLUE);
        FOG_RED = fogRed;
        FOG_GREEN = fogGreen;
        FOG_BLUE = fogBlue;
        FOG_NEAR = shaderFogStart;
        FOG_FAR = shaderFogEnd;
        FOG_SHAPE = shaderFogShape;
    }

    public static void renderBufferedBatches(PoseStack matrixStack) {
        RenderHandler.draw(DELAYED_RENDER, BUFFERS);
    }

    public static void endBufferedRendering(PoseStack poseStack) {
        LightTexture lightTexture = Minecraft.m_91087_().f_91063_.m_109154_();
        RenderSystem.setShaderFogStart((float)FOG_NEAR);
        RenderSystem.setShaderFogEnd((float)FOG_FAR);
        RenderSystem.setShaderFogShape((FogShape)FOG_SHAPE);
        RenderSystem.setShaderFogColor((float)FOG_RED, (float)FOG_GREEN, (float)FOG_BLUE);
        poseStack.m_85849_();
        lightTexture.m_109891_();
        RenderSystem.disableCull();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)true);
    }

    public static void draw(MultiBufferSource.BufferSource source, HashMap<RenderType, BufferBuilder> buffers) {
        for (RenderType type : buffers.keySet()) {
            ShaderInstance instance = RenderUtils.getShader(type);
            if (UNIFORM_HANDLERS.containsKey(type)) {
                ShaderUniformHandler handler = UNIFORM_HANDLERS.get(type);
                handler.updateShaderData(instance);
            }
            source.m_109912_(type);
            if (!(instance instanceof IJShader)) continue;
            IJShader jShader = (IJShader)instance;
            jShader.setUniformDefaults();
        }
        source.m_109911_();
    }

    public static void addRenderLayer(RenderType type) {
        int size = LARGER_BUFFER_SOURCES ? 262144 : type.m_110507_();
        HashMap<RenderType, BufferBuilder> buffers = BUFFERS;
        buffers.put(type, new BufferBuilder(size));
    }
}

