/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.rendering;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.pose.ModelType;
import net.arna.jcraft.api.pose.PoseModifiers;
import net.arna.jcraft.api.pose.modifier.IPoseModifier;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.client.command.JPoseCommand;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class StandUserPoseLoader {
    private static final Map<ResourceLocation, Map<ModelType<?>, IPoseModifier>> POSES = new HashMap();

    public static IPoseModifier getPose(ModelType<?> type, LivingEntity entity) {
        Entity entity2 = entity.m_146895_();
        if (entity2 instanceof StandEntity) {
            StandEntity stand = (StandEntity)entity2;
            return StandUserPoseLoader.getPose(type, stand.getUserPose());
        }
        if (JPoseCommand.hasPose(type)) {
            return JPoseCommand.getPose();
        }
        return IPoseModifier.EMPTY;
    }

    public static IPoseModifier getPose(ModelType<?> type, ResourceLocation id) {
        IPoseModifier pose = (IPoseModifier)POSES.getOrDefault(id, Collections.emptyMap()).get(type);
        if (pose == null) {
            if (JPoseCommand.hasPose(type)) {
                return JPoseCommand.getPose();
            }
            return IPoseModifier.EMPTY;
        }
        return pose;
    }

    public static CompletableFuture<Void> onReload(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller profilerFiller, ProfilerFiller profilerFiller1, Executor executor, Executor executor1) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> StandUserPoseLoader.loadPoses(resourceManager)).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).m_6769_(arg_0))).thenAcceptAsync(StandUserPoseLoader::parsePoses);
    }

    private static Map<ResourceLocation, JsonObject> loadPoses(ResourceManager resourceManager) {
        Gson gson = new Gson();
        HashMap<ResourceLocation, JsonObject> poseJsons = new HashMap<ResourceLocation, JsonObject>();
        Map resources = resourceManager.m_214159_("poses", loc -> loc.m_135815_().endsWith(".json") && loc.m_135815_().split("/").length == 3);
        for (Map.Entry entry : resources.entrySet()) {
            try {
                BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                try {
                    JsonObject obj = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                    poseJsons.put((ResourceLocation)entry.getKey(), obj);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException e) {
                JCraft.LOGGER.error("Failed to load pose {}", entry.getKey(), (Object)e);
            }
        }
        return poseJsons;
    }

    private static void parsePoses(Map<ResourceLocation, JsonObject> poseJsons) {
        POSES.clear();
        for (Map.Entry<ResourceLocation, JsonObject> entry : poseJsons.entrySet()) {
            ResourceLocation id = entry.getKey();
            JsonObject obj = entry.getValue();
            ResourceLocation standType = id.m_247266_(path -> path.split("/")[1]);
            String typeName = id.m_135815_().substring(id.m_135815_().lastIndexOf(47) + 1, id.m_135815_().length() - 5);
            ModelType<?> modelType = ModelType.fromName(typeName);
            if (modelType == null) {
                JCraft.LOGGER.error("Unknown model type {} for pose {}", (Object)typeName, (Object)id);
                continue;
            }
            DataResult res = PoseModifiers.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)obj);
            if (res.error().isPresent()) {
                JCraft.LOGGER.error("Failed to parse pose {}: {}", (Object)id, (Object)((DataResult.PartialResult)res.error().get()).message());
                continue;
            }
            IPoseModifier pose = (IPoseModifier)res.result().get();
            POSES.computeIfAbsent(standType, t -> new HashMap()).put(modelType, pose);
        }
    }
}

