/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.rendering.api;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.client.rendering.api.DynamicShaderFxInstance;
import net.arna.jcraft.client.rendering.api.PostProcessor;
import net.arna.jcraft.client.rendering.api.ShaderDataBuffer;
import net.minecraft.client.renderer.EffectInstance;

public abstract class MultiInstancePostProcessor<I extends DynamicShaderFxInstance>
extends PostProcessor {
    private final List<DynamicShaderFxInstance> instances = new ArrayList<DynamicShaderFxInstance>(this.getMaxInstances());
    private final ShaderDataBuffer dataBuffer = new ShaderDataBuffer();

    protected abstract int getMaxInstances();

    protected abstract int getDataSizePerInstance();

    @Override
    public void init() {
        super.init();
        this.dataBuffer.generate((long)this.getMaxInstances() * (long)this.getDataSizePerInstance());
    }

    @Nullable
    public I addFxInstance(I instance) {
        if (this.instances.size() >= this.getMaxInstances()) {
            JCraft.LOGGER.warn("Failed to add fx instance to " + String.valueOf(this) + ": reached max instance count of " + this.getMaxInstances());
            return null;
        }
        this.instances.add((DynamicShaderFxInstance)instance);
        this.setActive(true);
        return instance;
    }

    @Override
    public void beforeProcess(PoseStack viewModelStack) {
        for (int i = this.instances.size() - 1; i >= 0; --i) {
            DynamicShaderFxInstance instance = this.instances.get(i);
            instance.update(MC.m_91297_());
            if (!instance.isRemoved()) continue;
            this.instances.remove(i);
        }
        if (this.instances.isEmpty()) {
            this.setActive(false);
            return;
        }
        float[] data = new float[this.instances.size() * this.getDataSizePerInstance()];
        for (int ins = 0; ins < this.instances.size(); ++ins) {
            DynamicShaderFxInstance instance = this.instances.get(ins);
            int offset = ins * this.getDataSizePerInstance();
            instance.writeDataToBuffer((index, d) -> {
                if (index >= this.getDataSizePerInstance() || index < 0) {
                    throw new IndexOutOfBoundsException((int)index);
                }
                data[offset + index.intValue()] = d.floatValue();
            });
        }
        this.dataBuffer.upload(data);
    }

    protected void setDataBufferUniform(EffectInstance effectInstance, String bufferName, String countName) {
        this.dataBuffer.apply(effectInstance, bufferName);
        effectInstance.m_108952_(countName).m_142617_(this.instances.size());
    }
}

