/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.rendering.api;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.client.rendering.api.callbacks.DisplayResizeCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.resources.ResourceLocation;

public class PostEffect
implements DisplayResizeCallback {
    private static final Set<PostEffect> INSTANCES = Collections.newSetFromMap(new WeakHashMap());
    private final ResourceLocation location;
    private final Consumer<PostEffect> initCallback;
    private PostChain postChain;

    public PostEffect(ResourceLocation location) {
        this(location, e -> {});
    }

    public PostEffect(ResourceLocation location, Consumer<PostEffect> initCallback) {
        INSTANCES.add(this);
        this.location = location;
        this.initCallback = initCallback;
        DisplayResizeCallback.EVENT.register((Object)this);
    }

    public static void initAll() {
        INSTANCES.forEach(effect -> {
            try {
                effect.initialize();
            }
            catch (IOException e) {
                JCraft.LOGGER.error("Failed to initialize post effect {}", (Object)effect.getLocation(), (Object)e);
            }
        });
    }

    public void initialize() throws IOException {
        this.release(false);
        Minecraft mc = Minecraft.m_91087_();
        this.postChain = new PostChain(mc.m_91097_(), mc.m_91098_(), mc.m_91385_(), this.location);
        this.resize(mc.m_91268_().m_85441_(), mc.m_91268_().m_85442_());
    }

    public void resize(int width, int height) {
        if (!this.isInitialized()) {
            return;
        }
        this.postChain.m_110025_(width, height);
        this.initCallback.accept(this);
    }

    public Uniform getUniform(String name) {
        return this.postChain.f_110009_.stream().map(pass -> pass.m_110074_().m_108952_(name)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalArgumentException("Uniform not found: " + name));
    }

    public RenderTarget getRenderTarget(String name) {
        return Optional.ofNullable(this.postChain.m_110036_(name)).orElseThrow(() -> new IllegalArgumentException("Render target not found: " + name));
    }

    public void setSampler(String name, int textureId) {
        this.postChain.f_110009_.forEach(pass -> pass.m_110074_().m_108954_(name, () -> textureId));
    }

    public void release() {
        this.release(true);
    }

    private void release(boolean remove) {
        if (!this.isInitialized()) {
            return;
        }
        this.postChain.close();
        this.postChain = null;
        if (remove) {
            INSTANCES.remove(this);
        }
        DisplayResizeCallback.EVENT.unregister((Object)this);
    }

    public void render(float tickDelta) {
        if (this.postChain == null) {
            return;
        }
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.resetTextureMatrix();
        this.postChain.m_110023_(tickDelta);
        Minecraft.m_91087_().m_91385_().m_83947_(true);
        RenderSystem.disableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.enableDepthTest();
    }

    public boolean isInitialized() {
        return this.postChain != null;
    }

    @Override
    public void onResolutionChanged(int newWidth, int newHeight) {
        this.resize(newWidth, newHeight);
    }

    public ResourceLocation getLocation() {
        return this.location;
    }
}

