/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.rendering.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.client.rendering.api.PostEffect;
import net.arna.jcraft.client.rendering.handler.StandShaderHandler;
import net.arna.jcraft.mixin_logic.StillDepthHolder;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class ZaWarudoShaderHandler
extends StandShaderHandler {
    public static ZaWarudoShaderHandler INSTANCE = new ZaWarudoShaderHandler();
    public final ResourceLocation SHADER_ID = JCraft.id("shaders/post/za_warudo.json");
    public float prevRadius = 0.0f;
    public float radius = 0.0f;
    public long effectLength = 0L;
    @Nullable
    public LivingEntity shaderSourceEntity = null;
    private final PostEffect EFFECT = new PostEffect(this.SHADER_ID, this::setup);

    private void setup(PostEffect effect) {
        Minecraft mc = Minecraft.m_91087_();
        effect.setSampler("DepthSampler", ((StillDepthHolder)mc.m_91385_()).jcraft$getDepthTexture());
        effect.getUniform("ViewPort").m_142492_(0, 0, mc.m_91268_().m_85441_(), mc.m_91268_().m_85442_());
    }

    @Override
    public void onWorldRendered(@NonNull PoseStack matrices, @NonNull Camera camera, float tickDelta, long nanoTime) {
        if (matrices == null) {
            throw new NullPointerException("matrices is marked non-null but is null");
        }
        if (camera == null) {
            throw new NullPointerException("camera is marked non-null but is null");
        }
        if (this.renderingEffect) {
            this.EFFECT.getUniform("InverseTransformMatrix").m_5679_(ZaWarudoShaderHandler.getInverseTransformMatrix(this.projectionMatrix));
            Vec3 cameraPos = camera.m_90583_();
            this.EFFECT.getUniform("CameraPosition").m_5889_((float)cameraPos.f_82479_, (float)cameraPos.f_82480_, (float)cameraPos.f_82481_);
            if (this.shaderSourceEntity != null) {
                this.EFFECT.getUniform("Center").m_5889_(ZaWarudoShaderHandler.lerp(this.shaderSourceEntity.m_20185_(), this.shaderSourceEntity.f_19854_, tickDelta), ZaWarudoShaderHandler.lerp(this.shaderSourceEntity.m_20186_() + (double)(this.shaderSourceEntity.m_20206_() / 2.0f), this.shaderSourceEntity.f_19855_ + (double)(this.shaderSourceEntity.m_20206_() / 2.0f), tickDelta), ZaWarudoShaderHandler.lerp(this.shaderSourceEntity.m_20189_(), this.shaderSourceEntity.f_19856_, tickDelta));
            }
            this.EFFECT.getUniform("Radius").m_5985_(Math.max(0.0f, ZaWarudoShaderHandler.lerp(this.radius, this.prevRadius, tickDelta)));
        }
    }

    public void tick(Minecraft client) {
        if (!this.shouldRender) {
            this.renderingEffect = false;
            return;
        }
        if (!this.renderingEffect) {
            this.EFFECT.getUniform("OuterSat").m_5985_(1.0f);
            this.ticks = 0;
            this.radius = 0.0f;
            this.renderingEffect = true;
        }
        ++this.ticks;
        this.prevRadius = this.radius;
        float expansionRate = 4.0f;
        int inversion = 100 / (int)expansionRate;
        if (this.ticks < inversion) {
            this.radius += expansionRate;
        } else if (this.ticks == inversion) {
            this.EFFECT.getUniform("OuterSat").m_5985_(0.3f);
        } else if (this.ticks < 2 * inversion) {
            this.radius -= 2.0f * expansionRate;
        }
        if ((long)this.ticks > this.effectLength) {
            this.renderingEffect = false;
            this.shouldRender = false;
        }
    }

    @Override
    public void renderEffect(float tickDelta) {
        if (!this.renderingEffect) {
            return;
        }
        this.EFFECT.render(tickDelta);
    }

    private static Matrix4f getInverseTransformMatrix(Matrix4f outMat) {
        Matrix4f projection = RenderSystem.getProjectionMatrix();
        Matrix4f modelView = RenderSystem.getModelViewMatrix();
        outMat.identity();
        outMat.mul((Matrix4fc)projection);
        outMat.mul((Matrix4fc)modelView);
        outMat.invert();
        return outMat;
    }

    private static float lerp(double n, double prevN, float tickDelta) {
        return (float)Mth.m_14139_((double)tickDelta, (double)prevN, (double)n);
    }
}

