/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.rendering.post;

import com.mojang.blaze3d.vertex.PoseStack;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.client.rendering.api.MultiInstancePostProcessor;
import net.arna.jcraft.client.rendering.post.TimestopShaderFX;
import net.arna.jcraft.client.util.Easing;
import net.arna.jcraft.platform.JPlatformUtils;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;

public class TimestopShaderPostProcessor
extends MultiInstancePostProcessor<TimestopShaderFX> {
    private EffectInstance timeStopEffect;
    private float duration = 1.0f;
    private Vector3f centerWorldPos = new Vector3f(0.5f, 70.0f, 0.5f);

    @Override
    protected int getMaxInstances() {
        return 4;
    }

    @Override
    protected int getDataSizePerInstance() {
        return 4;
    }

    @Override
    public void init() {
        if (this.shaderEffect != null) {
            this.timeStopEffect = this.effects[0];
        }
    }

    @Override
    public ResourceLocation getShaderEffectId() {
        return JCraft.id("za_warudo");
    }

    @Override
    public void beforeProcess(PoseStack viewModelStack) {
        float progress = (float)(this.time / (double)this.duration);
        if (progress > 1.0f) {
            this.setActive(false);
            return;
        }
        this.timeStopEffect.m_108952_("Center").m_142276_(this.centerWorldPos);
    }

    @Override
    public void afterProcess() {
        this.setDataBufferUniform(this.timeStopEffect, "Data", "instanceCount");
    }

    public static void playEffect(Vector3f center) {
        Runnable timeStop = () -> JPlatformUtils.getZaWarudo().addFxInstance(new TimestopShaderFX(center){

            @Override
            public void update(double deltaTime) {
                super.update(deltaTime);
                float t = this.getTime() / 7.5f;
                if (t < 1.0f) {
                    t = Easing.CIRC_OUT.ease(t, 0.0f, 1.0f, 1.0f);
                }
                this.virtualRadius = t * 300.0f;
                if (this.virtualRadius > 1300.0f) {
                    this.remove();
                }
            }
        });
    }
}

