/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.rendering.skybox;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Objects;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.client.rendering.skybox.JSkyBox;
import net.arna.jcraft.client.rendering.skybox.Rotation;
import net.arna.jcraft.client.rendering.skybox.Textures;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class CrimsonSkyBoxCool
implements JSkyBox {
    public Rotation rotation = Rotation.DEFAULT;
    public float alpha = 10.0f;
    protected Textures.Texture texture = new Textures.Texture(JCraft.id("textures/environment/time_erase/space.png"));
    public Textures textures = new Textures(this.texture.withUV(0.33333334f, 0.5f, 0.6666667f, 1.0f), this.texture.withUV(0.6666667f, 0.0f, 1.0f, 0.5f), this.texture.withUV(0.6666667f, 0.5f, 1.0f, 1.0f), this.texture.withUV(0.0f, 0.5f, 0.33333334f, 1.0f), this.texture.withUV(0.33333334f, 0.0f, 0.6666667f, 0.5f), this.texture.withUV(0.0f, 0.0f, 0.33333334f, 0.5f));

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    private boolean isShouldRotate() {
        return true;
    }

    @Override
    public void render(PoseStack matrices, Matrix4f matrix4f, float tickDelta, Camera camera, boolean thickFog) {
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        ClientLevel world = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        Vector3f rotationStatic = this.rotation.staticRot();
        matrices.m_85836_();
        double timeRotation = this.isShouldRotate() ? 360.0 * Mth.m_14109_((double)((double)world.m_8044_() / (24000.0 / (double)this.rotation.rotationSpeed()) + 0.75), (double)1.0) : 0.0;
        this.applyTimeRotation(matrices, (float)timeRotation);
        matrices.m_252781_(Axis.f_252529_.m_252977_(rotationStatic.x()));
        matrices.m_252781_(Axis.f_252436_.m_252977_(rotationStatic.y()));
        matrices.m_252781_(Axis.f_252403_.m_252977_(rotationStatic.z()));
        this.renderSkybox(matrices, tickDelta);
        matrices.m_252781_(Axis.f_252403_.m_252977_(rotationStatic.z()));
        matrices.m_252781_(Axis.f_252436_.m_252977_(rotationStatic.y()));
        matrices.m_252781_(Axis.f_252529_.m_252977_(rotationStatic.x()));
        matrices.m_85849_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderSkybox(PoseStack matrices, float tickDelta) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        for (int i = 0; i < 6; ++i) {
            Textures.Texture tex = this.textures.byId(i);
            matrices.m_85836_();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)tex.textureId());
            if (i == 1) {
                matrices.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            } else if (i == 2) {
                matrices.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                matrices.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            } else if (i == 3) {
                matrices.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            } else if (i == 4) {
                matrices.m_252781_(Axis.f_252403_.m_252977_(90.0f));
                matrices.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            } else if (i == 5) {
                matrices.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
                matrices.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            }
            Matrix4f matrix4f = matrices.m_85850_().m_252922_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            bufferBuilder.m_252986_(matrix4f, -100.0f, -100.0f, -100.0f).m_7421_(tex.minU(), tex.minV()).m_85950_(1.0f, 1.0f, 1.0f, this.alpha).m_5752_();
            bufferBuilder.m_252986_(matrix4f, -100.0f, -100.0f, 100.0f).m_7421_(tex.minU(), tex.maxV()).m_85950_(1.0f, 1.0f, 1.0f, this.alpha).m_5752_();
            bufferBuilder.m_252986_(matrix4f, 100.0f, -100.0f, 100.0f).m_7421_(tex.maxU(), tex.maxV()).m_85950_(1.0f, 1.0f, 1.0f, this.alpha).m_5752_();
            bufferBuilder.m_252986_(matrix4f, 100.0f, -100.0f, -100.0f).m_7421_(tex.maxU(), tex.minV()).m_85950_(1.0f, 1.0f, 1.0f, this.alpha).m_5752_();
            tesselator.m_85914_();
            matrices.m_85849_();
        }
    }

    private void applyTimeRotation(PoseStack matrices, float timeRotation) {
        Vector3f timeRotationAxis = this.rotation.axisRot();
        matrices.m_252781_(Axis.f_252529_.m_252977_(timeRotationAxis.x()));
        matrices.m_252781_(Axis.f_252436_.m_252977_(timeRotationAxis.y()));
        matrices.m_252781_(Axis.f_252403_.m_252977_(timeRotationAxis.z()));
        matrices.m_252781_(Axis.f_252436_.m_252977_(timeRotation));
        matrices.m_252781_(Axis.f_252393_.m_252977_(timeRotationAxis.z()));
        matrices.m_252781_(Axis.f_252392_.m_252977_(timeRotationAxis.y()));
        matrices.m_252781_(Axis.f_252495_.m_252977_(timeRotationAxis.x()));
    }
}

