/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.util;

import java.util.List;
import java.util.UUID;
import lombok.NonNull;
import net.arna.jcraft.api.component.living.CommonBombTrackerComponent;
import net.arna.jcraft.api.registry.JParticleTypeRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.client.JClientConfig;
import net.arna.jcraft.client.particle.AuraArcParticle;
import net.arna.jcraft.client.particle.AuraBlobParticle;
import net.arna.jcraft.client.util.JClientUtils;
import net.arna.jcraft.common.entity.SheerHeartAttackEntity;
import net.arna.jcraft.common.entity.stand.AbstractPurpleHazeEntity;
import net.arna.jcraft.common.entity.stand.HGEntity;
import net.arna.jcraft.common.entity.stand.MetallicaEntity;
import net.arna.jcraft.common.entity.stand.WhiteSnakeEntity;
import net.arna.jcraft.common.entity.vehicle.AbstractGroundVehicleEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.arna.jcraft.common.util.IClientEntityHandler;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class ClientEntityHandlerImpl
implements IClientEntityHandler {
    public static final ClientEntityHandlerImpl INSTANCE = new ClientEntityHandlerImpl();
    private static final double metersPerTickSquared = 0.024525;

    private ClientEntityHandlerImpl() {
    }

    @Override
    public void bombTrackerParticleTick(Entity entity, CommonBombTrackerComponent.BombData bombData) {
        Vec3 bombPos = bombData.getBombPos();
        if (bombPos == null) {
            return;
        }
        ClientLevel clientWorld = (ClientLevel)entity.m_9236_();
        SimpleParticleType particleType = ParticleTypes.f_123771_;
        Vec3 v1 = bombPos.m_82520_(3.0, 3.0, 3.0);
        Vec3 v2 = bombPos.m_82520_(-3.0, -3.0, -3.0);
        List list = clientWorld.m_6443_(LivingEntity.class, new AABB(v1, v2), EntitySelector.f_20403_);
        double xLength = 0.0;
        double yLength = 0.0;
        double zLength = 0.0;
        if (!bombData.isBlock) {
            Object bombEntity = bombData.bombEntity;
            if (bombEntity == null) {
                bombEntity = bombData.bombItem.m_41609_();
            }
            if (bombEntity == null) {
                return;
            }
            list.remove(bombEntity);
            xLength = bombEntity.m_20191_().m_82362_();
            yLength = bombEntity.m_20191_().m_82376_();
            zLength = bombEntity.m_20191_().m_82385_();
        }
        for (LivingEntity l : list) {
            if (!(l.m_20238_(bombPos) < 9.0)) continue;
            particleType = ParticleTypes.f_175828_;
            break;
        }
        RandomSource random = clientWorld.m_213780_();
        if (bombData.isEntity) {
            for (int h = 0; h < 16; ++h) {
                clientWorld.m_7106_((ParticleOptions)particleType, bombPos.f_82479_ + random.m_216328_(0.0, 1.0) * xLength, bombPos.f_82480_ + random.m_216328_(0.0, 1.0) * yLength, bombPos.f_82481_ + random.m_216328_(0.0, 1.0) * zLength, 0.0, 0.0, 0.0);
            }
        }
        if (bombData.isBlock) {
            for (int h = 0; h < 16; ++h) {
                clientWorld.m_7106_((ParticleOptions)particleType, bombPos.f_82479_ + random.m_188500_(), bombPos.f_82480_ + random.m_188500_(), bombPos.f_82481_ + random.m_188500_(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void standEntityClientTick(StandEntity<?, ?> stand) {
        LivingEntity user = stand.getUserOrThrow();
        Minecraft client = Minecraft.m_91087_();
        if (JClientConfig.getInstance().isStandAuras() && JClientUtils.shouldRenderStands()) {
            if (stand.m_20280_((Entity)client.f_91074_) > 6400.0) {
                return;
            }
            if (user.m_20145_() || stand.m_20145_()) {
                return;
            }
            boolean isFP = client.f_91066_.m_92176_().m_90612_();
            boolean isOwnerAndFP = user == client.f_91074_ && isFP;
            ClientLevel clientWorld = (ClientLevel)stand.m_9236_();
            RandomSource random = clientWorld.m_213780_();
            Direction gravity = GravityChangerAPI.getGravityDirection(stand);
            Vector3f auraColor = stand.getAuraColor();
            if (!(isOwnerAndFP && !stand.isFree() || stand.isRemoteAndControllable() && isFP || !random.m_188499_())) {
                this.displayAuraParticles(clientWorld, random, (Entity)stand, RotationUtil.vecPlayerToWorld(stand.m_20205_(), stand.m_20206_(), stand.m_20205_(), gravity), gravity, auraColor);
            }
            if (!isOwnerAndFP && random.m_188499_() && !JClientUtils.shouldNotRender((Entity)user)) {
                this.displayAuraParticles(clientWorld, random, (Entity)user, RotationUtil.vecPlayerToWorld(user.m_20205_(), user.m_20206_(), user.m_20205_(), gravity), gravity, auraColor);
            }
        }
    }

    private void displayAuraParticles(ClientLevel clientWorld, RandomSource random, Entity entity, Vector3f maxBox, Direction gravity, Vector3f color) {
        this.displayAuraParticles(clientWorld, random, entity, maxBox, gravity, color, false);
    }

    private void displayAuraParticles(ClientLevel clientWorld, RandomSource random, Entity entity, Vector3f maxBox, Direction gravity, Vector3f color, boolean overrideNoRender) {
        if (!overrideNoRender && JClientUtils.shouldNotRender(entity)) {
            return;
        }
        Vec3 pos = entity.m_20182_();
        Vec3 vel = Vec3.m_82528_((Vec3i)gravity.m_122436_()).m_82490_(-0.024525);
        AuraArcParticle.Factory.parent = entity;
        AuraArcParticle.Factory.color = color;
        AuraBlobParticle.Factory.parent = entity;
        AuraBlobParticle.Factory.color = color;
        clientWorld.m_6493_((ParticleOptions)JParticleTypeRegistry.AURA_ARC.get(), false, pos.f_82479_ + (double)maxBox.x() * random.m_216328_(0.0, 1.0), pos.f_82480_ + (double)maxBox.y() * random.m_216328_(0.5, 0.5), pos.f_82481_ + (double)maxBox.z() * random.m_216328_(0.0, 1.0), vel.f_82479_, vel.f_82480_, vel.f_82481_);
        clientWorld.m_6493_((ParticleOptions)JParticleTypeRegistry.AURA_BLOB.get(), false, pos.f_82479_ + (double)maxBox.x() * random.m_216328_(0.0, 1.0), pos.f_82480_ + (double)maxBox.y() * random.m_216328_(0.5, 0.5), pos.f_82481_ + (double)maxBox.z() * random.m_216328_(0.0, 1.0), vel.f_82479_, vel.f_82480_, vel.f_82481_);
    }

    @Override
    public void displayMetallicaAura(MetallicaEntity metallica) {
        LivingEntity user = metallica.getUser();
        if (user == null || !JClientUtils.shouldRenderStands()) {
            return;
        }
        Direction gravity = GravityChangerAPI.getGravityDirection((Entity)metallica);
        Vector3f auraColor = metallica.getAuraColor();
        this.displayAuraParticles((ClientLevel)metallica.m_9236_(), metallica.m_217043_(), (Entity)metallica, RotationUtil.vecPlayerToWorld(user.m_20205_(), user.m_20206_(), user.m_20205_(), gravity), gravity, auraColor, true);
    }

    @Override
    public void whiteSnakeRemoteClientTick(@NonNull WhiteSnakeEntity whiteSnakeEntity) {
        if (whiteSnakeEntity == null) {
            throw new NullPointerException("whiteSnakeEntity is marked non-null but is null");
        }
        Minecraft client = Minecraft.m_91087_();
        if (JUtils.getStand((LivingEntity)client.f_91074_) != whiteSnakeEntity) {
            return;
        }
        Options options = client.f_91066_;
        float f = 0.0f;
        float s = 0.0f;
        boolean jump = options.f_92089_.m_90857_();
        if (options.f_92085_.m_90857_()) {
            f += 1.0f;
        }
        if (options.f_92087_.m_90857_()) {
            f += 1.0f;
        }
        if (options.f_92086_.m_90857_()) {
            s -= 1.0f;
        }
        if (options.f_92088_.m_90857_()) {
            s += 1.0f;
        }
        whiteSnakeEntity.tickRemoteMovement(f, s, jump);
    }

    @Override
    public void purpleHazeRemoteClientTick(@NonNull AbstractPurpleHazeEntity<?, ?> purpleHazeEntity) {
        if (purpleHazeEntity == null) {
            throw new NullPointerException("purpleHazeEntity is marked non-null but is null");
        }
        Minecraft client = Minecraft.m_91087_();
        if (JUtils.getStand((LivingEntity)client.f_91074_) != purpleHazeEntity) {
            return;
        }
        Options options = client.f_91066_;
        float f = 0.0f;
        float s = 0.0f;
        boolean jump = options.f_92089_.m_90857_();
        if (options.f_92085_.m_90857_()) {
            f += 1.0f;
        }
        if (options.f_92087_.m_90857_()) {
            f += 1.0f;
        }
        if (options.f_92086_.m_90857_()) {
            s -= 1.0f;
        }
        if (options.f_92088_.m_90857_()) {
            s += 1.0f;
        }
        purpleHazeEntity.tickRemoteMovement(f, s, jump);
    }

    @Override
    public void hierophantGreenRemoteClientTick(@NonNull HGEntity hgEntity) {
        if (hgEntity == null) {
            throw new NullPointerException("hgEntity is marked non-null but is null");
        }
        Minecraft client = Minecraft.m_91087_();
        if (JUtils.getStand((LivingEntity)client.f_91074_) != hgEntity) {
            return;
        }
        Options options = client.f_91066_;
        float f = 0.0f;
        float s = 0.0f;
        boolean jump = options.f_92089_.m_90857_();
        boolean sneak = options.f_92090_.m_90857_();
        if (options.f_92085_.m_90857_()) {
            f += 1.0f;
        }
        if (options.f_92087_.m_90857_()) {
            f += 1.0f;
        }
        if (options.f_92086_.m_90857_()) {
            s -= 1.0f;
        }
        if (options.f_92088_.m_90857_()) {
            s += 1.0f;
        }
        hgEntity.tickRemoteMovement(f, s, jump, sneak);
    }

    @Override
    public void sheerHeartAttackEntityTick(SheerHeartAttackEntity sHAEntity) {
        Minecraft client = Minecraft.m_91087_();
        UUID ownerId = sHAEntity.getOwnerId();
        if (ownerId == null) {
            return;
        }
        if (ownerId.equals(client.f_91074_.m_20148_()) && sHAEntity.f_19797_ <= 300) {
            sHAEntity.m_6593_((Component)Component.m_237113_((String)(15 - sHAEntity.f_19797_ / 20 + "s")));
        }
    }

    @Override
    public void vehicleMovementTick(AbstractGroundVehicleEntity vehicle) {
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91074_ == vehicle.m_146895_()) {
            Options options = client.f_91066_;
            boolean w = options.f_92085_.m_90857_();
            boolean a = options.f_92086_.m_90857_();
            boolean s = options.f_92087_.m_90857_();
            boolean d = options.f_92088_.m_90857_();
            boolean jump = options.f_92089_.m_90857_();
            boolean sneak = options.f_92090_.m_90857_();
            vehicle.movementTick(w, a, s, d, jump, sneak);
        }
    }
}

