/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import mod.azure.azurelib.core.animatable.model.CoreGeoBone;
import mod.azure.azurelib.core.animation.AnimationProcessor;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.client.model.entity.stand.StandEntityModel;
import net.arna.jcraft.common.entity.stand.CreamEntity;
import net.arna.jcraft.common.entity.stand.D4CEntity;
import net.arna.jcraft.common.entity.stand.KingCrimsonEntity;
import net.arna.jcraft.common.entity.stand.MetallicaEntity;
import net.arna.jcraft.common.util.DimensionData;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class JClientUtils {
    public static final List<DimensionData> activeTimestops = new ArrayList<DimensionData>();
    public static final Map<Entity, Double> timestopTimestamps = new WeakHashMap<Entity, Double>();

    public static void removeTimestop(int timestopperId) {
        for (DimensionData timestop : activeTimestops) {
            LivingEntity timestopper = timestop.getUser();
            if (timestopper.m_19879_() != timestopperId) continue;
            timestop.setTimer(0);
            return;
        }
    }

    public static boolean isInTSRange(Entity entity) {
        if (entity == null) {
            return false;
        }
        return JClientUtils.isInTSRange(entity.m_20182_());
    }

    public static boolean isInTSRange(Vec3 pos) {
        for (DimensionData timeStop : activeTimestops) {
            if (timeStop == null || !(timeStop.getPos().m_82531_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_()) <= 65536.0)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInTSRange(BlockPos pos) {
        for (DimensionData timeStop : activeTimestops) {
            if (timeStop == null || !(timeStop.getPos().m_82531_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) <= 65536.0)) continue;
            return true;
        }
        return false;
    }

    public static int getTicksIfInTSRange(BlockPos pos) {
        for (DimensionData timeStop : activeTimestops) {
            if (timeStop == null || !(timeStop.getPos().m_82531_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) <= 65536.0)) continue;
            return timeStop.getTimer();
        }
        return 0;
    }

    public static void animateGenericHumanoid(StandEntityModel<?> model, StandEntity<?, ?> entity, LivingEntity player, float partialTick) {
        JClientUtils.animateGenericHumanoid(model, entity, player, partialTick, false, false);
    }

    public static void animateGenericHumanoid(StandEntityModel<?> model, StandEntity<?, ?> entity, LivingEntity player, float partialTick, boolean flipBody, boolean flipHead) {
        JClientUtils.animateGenericHumanoid(model, entity, player, partialTick, flipBody, flipHead, 0.0f, 0.0f, 90.0f);
    }

    public static void animateGenericHumanoid(StandEntityModel<?> model, StandEntity<?, ?> entity, LivingEntity player, float partialTick, boolean flipBody, boolean flipHead, float tPO, float hPO) {
        JClientUtils.animateGenericHumanoid(model, entity, player, partialTick, flipBody, flipHead, tPO, hPO, 90.0f);
    }

    public static void animateGenericHumanoid(StandEntityModel<?> model, StandEntity<?, ?> entity, LivingEntity player, float partialTick, boolean flipBody, boolean flipHead, float tPO, float hPO, float velInfluence) {
        CoreGeoBone base;
        float overVel = 0.0f;
        AnimationProcessor animationProcessor = model.getAnimationProcessor();
        if (entity.getMoveStun() < 1) {
            CoreGeoBone torso;
            Vec3 playerVel = entity.isRemote() && !entity.remoteControllable() ? entity.m_20184_() : JUtils.deltaPos((Entity)player);
            overVel = Mth.m_14036_((float)((float)playerVel.m_165924_() - 0.05f), (float)-1.0f, (float)1.0f);
            if (playerVel.m_82541_().m_82549_(entity.m_20154_()).m_165925_() < playerVel.m_82541_().m_165925_()) {
                velInfluence *= -1.0f;
            }
            if ((torso = animationProcessor.getBone("torso")) != null) {
                float pitch = (180.0f + overVel * velInfluence) * 3.1415f / 180.0f;
                if (flipBody) {
                    pitch += 3.1415f;
                    pitch = -pitch;
                }
                torso.setRotX(pitch + tPO);
            }
        }
        if (entity.m_21254_() || entity.isIdle()) {
            CoreGeoBone head = animationProcessor.getBone("head");
            if (head != null) {
                float headPitch = (player.m_146909_() - overVel * velInfluence) * 3.1415f / 180.0f;
                if (flipHead) {
                    headPitch = -headPitch;
                }
                head.setRotX(headPitch + hPO);
            }
        } else if (entity.getMoveStun() > 0 && entity.shouldOffsetHeight() && (base = animationProcessor.getBone("base")) != null) {
            float torsoPitch = player.m_146909_() * 0.9f * 3.1415f / 180.0f;
            base.setRotX(base.getRotX() - torsoPitch);
        }
    }

    public static boolean shouldForceRender(Entity entity) {
        CreamEntity cream;
        KingCrimsonEntity kc;
        D4CEntity d4c;
        if (entity instanceof D4CEntity && (d4c = (D4CEntity)entity).getState() == D4CEntity.State.FLAG || entity instanceof KingCrimsonEntity && (kc = (KingCrimsonEntity)entity).getTETime() > 0 && kc.getUser() == Minecraft.m_91087_().f_91074_) {
            return true;
        }
        return entity instanceof CreamEntity && (cream = (CreamEntity)entity).isHalfBall();
    }

    public static boolean shouldNotRender(Entity entity) {
        MetallicaEntity metallica;
        CreamEntity cream;
        D4CEntity d4c;
        KingCrimsonEntity kc;
        Entity passenger = entity.m_146895_();
        return passenger instanceof KingCrimsonEntity && (kc = (KingCrimsonEntity)passenger).getTETime() > 0 || passenger instanceof D4CEntity && (d4c = (D4CEntity)passenger).getState() == D4CEntity.State.FLAG || passenger instanceof CreamEntity && (cream = (CreamEntity)passenger).isHalfBall() || passenger instanceof MetallicaEntity && (metallica = (MetallicaEntity)passenger).m_20145_();
    }

    public static void resetPartAngles(ModelPart part) {
        PartPose defaultTransform = part.m_233566_();
        part.f_104203_ = defaultTransform.f_171408_;
        part.f_104204_ = defaultTransform.f_171409_;
        part.f_104205_ = defaultTransform.f_171410_;
    }

    public static void animateHit(CommonHitPropertyComponent.HitAnimation hitAnimation, long endHitAnimTime, Vec3 randomRotation, ModelPart head, @Nullable ModelPart hat, ModelPart body, ModelPart rightArm, ModelPart leftArm, ModelPart rightLeg, ModelPart leftLeg) {
        if (endHitAnimTime > 20L) {
            endHitAnimTime = 20L;
        }
        float angDegrees = (float)endHitAnimTime * ((float)Math.PI / 180);
        if (endHitAnimTime <= 1L) {
            leftLeg.m_233569_();
            rightLeg.m_233569_();
            JClientUtils.resetPartAngles(body);
        } else {
            body.f_104204_ = (float)(randomRotation.f_82479_ * (double)angDegrees * 0.35);
            body.f_104205_ = (float)(randomRotation.f_82481_ * (double)angDegrees * 0.35);
        }
        if (endHitAnimTime == 0L) {
            return;
        }
        switch (hitAnimation) {
            case HIGH: {
                head.f_104203_ += (angDegrees *= 1.5f);
                body.f_104203_ -= angDegrees;
                leftLeg.f_104202_ -= (float)endHitAnimTime * 0.25f;
                rightLeg.f_104202_ -= (float)endHitAnimTime * 0.25f;
                rightArm.f_104205_ += angDegrees;
                leftArm.f_104205_ -= angDegrees;
                break;
            }
            case MID: {
                head.f_104203_ += (angDegrees *= 1.5f);
                body.f_104203_ += angDegrees;
                leftLeg.f_104202_ += (float)endHitAnimTime * 0.25f;
                rightLeg.f_104202_ += (float)endHitAnimTime * 0.25f;
                leftLeg.f_104201_ -= (float)endHitAnimTime * 0.175f;
                rightLeg.f_104201_ -= (float)endHitAnimTime * 0.175f;
                rightLeg.f_104203_ -= angDegrees;
                leftLeg.f_104203_ -= angDegrees;
                break;
            }
            case LOW: {
                head.f_104203_ += (angDegrees *= 1.5f);
                body.f_104203_ += angDegrees;
                leftLeg.f_104202_ += (float)endHitAnimTime * 0.175f;
                rightLeg.f_104202_ += (float)endHitAnimTime * 0.175f;
                leftLeg.f_104201_ -= (float)endHitAnimTime * 0.0875f;
                rightLeg.f_104201_ -= (float)endHitAnimTime * 0.0875f;
                rightLeg.f_104203_ += angDegrees;
                leftLeg.f_104203_ += angDegrees;
                rightArm.f_104205_ += angDegrees;
                leftArm.f_104205_ -= angDegrees;
                break;
            }
            case CRUSH: {
                body.f_104203_ += angDegrees;
                leftLeg.f_104202_ += (float)endHitAnimTime * 0.25f;
                rightLeg.f_104202_ += (float)endHitAnimTime * 0.25f;
                leftLeg.f_104201_ -= (float)endHitAnimTime * 0.175f;
                rightLeg.f_104201_ -= (float)endHitAnimTime * 0.175f;
                head.f_104203_ += Mth.m_14031_((float)((float)endHitAnimTime * 0.1f));
                rightArm.f_104205_ += (angDegrees *= 1.75f);
                leftArm.f_104205_ -= angDegrees;
                rightLeg.f_104203_ -= angDegrees;
                leftLeg.f_104203_ -= angDegrees;
                break;
            }
            case LAUNCH: {
                head.f_104203_ += angDegrees;
                body.f_104203_ += angDegrees;
                leftLeg.f_104202_ += (float)endHitAnimTime * 0.125f;
                rightLeg.f_104202_ += (float)endHitAnimTime * 0.125f;
                leftLeg.f_104201_ -= (float)endHitAnimTime * 0.125f;
                rightLeg.f_104201_ -= (float)endHitAnimTime * 0.125f;
                rightArm.f_104205_ += angDegrees;
                leftArm.f_104205_ -= angDegrees;
                rightLeg.f_104203_ -= angDegrees;
                leftLeg.f_104203_ -= angDegrees;
                break;
            }
        }
    }

    public static boolean shouldRenderStands() {
        return JUtils.shouldRenderStandsFor((Player)Minecraft.m_91087_().f_91074_);
    }
}

