/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.util;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.awt.Color;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public final class RenderUtils {
    public static final int FULL_BRIGHT = 0xF000F0;

    public static ShaderInstance getShader(RenderType type) {
        if (type instanceof RenderType.CompositeRenderType) {
            RenderType.CompositeRenderType compositeRenderType = (RenderType.CompositeRenderType)type;
            Optional shader = compositeRenderType.f_110511_.f_173274_.f_173136_;
            if (shader.isPresent()) {
                return (ShaderInstance)((Supplier)shader.get()).get();
            }
        }
        return null;
    }

    public static void renderGuiQuad(BufferBuilder buffer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        RenderSystem.setShader(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_5483_((double)x, (double)y, 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        buffer.m_5483_((double)x, (double)(y + height), 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        buffer.m_5483_((double)(x + width), (double)(y + height), 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        buffer.m_5483_((double)(x + width), (double)y, 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
    }

    public static void vertexPos(VertexConsumer vertexConsumer, Matrix4f last, float x, float y, float z) {
        vertexConsumer.m_252986_(last, x, y, z).m_5752_();
    }

    public static void vertexPosUV(VertexConsumer vertexConsumer, Matrix4f last, float x, float y, float z, float u, float v) {
        vertexConsumer.m_252986_(last, x, y, z).m_7421_(u, v).m_5752_();
    }

    public static void vertexPosUVLight(VertexConsumer vertexConsumer, Matrix4f last, float x, float y, float z, float u, float v, int light) {
        vertexConsumer.m_252986_(last, x, y, z).m_7421_(u, v).m_85969_(light).m_5752_();
    }

    public static void vertexPosColor(VertexConsumer vertexConsumer, Matrix4f last, float x, float y, float z, float r, float g, float b, float a) {
        vertexConsumer.m_252986_(last, x, y, z).m_85950_(r, g, b, a).m_5752_();
    }

    public static void vertexPosColorUV(VertexConsumer vertexConsumer, Matrix4f last, float x, float y, float z, float r, float g, float b, float a, float u, float v) {
        vertexConsumer.m_252986_(last, x, y, z).m_85950_(r, g, b, a).m_7421_(u, v).m_5752_();
    }

    public static void vertexPosColorUVLight(VertexConsumer vertexConsumer, Matrix4f last, float x, float y, float z, float r, float g, float b, float a, float u, float v, int light) {
        vertexConsumer.m_252986_(last, x, y, z).m_85950_(r, g, b, a).m_7421_(u, v).m_85969_(light).m_5752_();
    }

    public static float distSqr(float ... a) {
        float d = 0.0f;
        for (float f : a) {
            d += f * f;
        }
        return d;
    }

    public static float distance(float ... a) {
        return Mth.m_14116_((float)RenderUtils.distSqr(a));
    }

    public static void renderBlockAtPosition(PoseStack matrixStack, Camera camera, Vec3 pos, ResourceLocation texture, float alpha) {
        RenderUtils.renderBlockAtPosition(matrixStack, camera, pos, texture, alpha, GameRenderer::m_172814_);
    }

    public static void renderBlock(PoseStack matrixStack, VertexConsumer vertexConsumer) {
        Matrix4f matrix4f = matrixStack.m_85850_().m_252922_();
        RenderUtils.renderSide(matrix4f, vertexConsumer, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        RenderUtils.renderSide(matrix4f, vertexConsumer, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        RenderUtils.renderSide(matrix4f, vertexConsumer, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
        RenderUtils.renderSide(matrix4f, vertexConsumer, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f);
        RenderUtils.renderSide(matrix4f, vertexConsumer, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f);
    }

    private static void renderSide(Matrix4f model, VertexConsumer vertices, float x1, float x2, float y1, float y2, float z1, float z2, float z3, float z4) {
        vertices.m_252986_(model, x1, y1, z1).m_5752_();
        vertices.m_252986_(model, x2, y1, z2).m_5752_();
        vertices.m_252986_(model, x2, y2, z3).m_5752_();
        vertices.m_252986_(model, x1, y2, z4).m_5752_();
    }

    public static void renderBlockAtPosition(PoseStack matrixStack, Camera camera, Vec3 pos, ResourceLocation texture, float alpha, Supplier<ShaderInstance> shader) {
        matrixStack.m_85836_();
        Vec3 transformedPos = pos.m_82546_(camera.m_90583_());
        matrixStack.m_85837_(transformedPos.f_82479_, transformedPos.f_82480_, transformedPos.f_82481_);
        Matrix4f positionMatrix = matrixStack.m_85850_().m_252922_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        Color color = new Color(255, 255, 255);
        int intColor = color.getRGB();
        for (Direction direction : Direction.values()) {
            float x1 = direction == Direction.WEST || direction == Direction.DOWN || direction == Direction.NORTH ? 1.0f : 0.0f;
            float x2 = direction == Direction.EAST || direction == Direction.UP || direction == Direction.SOUTH ? 1.0f : 0.0f;
            float y1 = direction == Direction.DOWN || direction == Direction.NORTH || direction == Direction.WEST ? 1.0f : 0.0f;
            float y2 = direction == Direction.UP || direction == Direction.SOUTH || direction == Direction.EAST ? 1.0f : 0.0f;
            float z1 = direction == Direction.NORTH || direction == Direction.UP || direction == Direction.WEST ? 1.0f : 0.0f;
            float z2 = direction == Direction.SOUTH || direction == Direction.DOWN || direction == Direction.EAST ? 1.0f : 0.0f;
            buffer.m_252986_(positionMatrix, x1, y1, z1).m_193479_(intColor).m_7421_(0.0f, 1.0f).m_5752_();
            buffer.m_252986_(positionMatrix, x1, y2, z2).m_193479_(intColor).m_7421_(0.0f, 0.0f).m_5752_();
            buffer.m_252986_(positionMatrix, x2, y2, z2).m_193479_(intColor).m_7421_(1.0f, 0.0f).m_5752_();
            buffer.m_252986_(positionMatrix, x2, y1, z1).m_193479_(intColor).m_7421_(1.0f, 1.0f).m_5752_();
        }
        RenderSystem.setShader(shader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        tesselator.m_85914_();
        matrixStack.m_85849_();
    }

    public static void startOverlayRender() {
        Window window = Minecraft.m_91087_().m_91268_();
        RenderSystem.backupProjectionMatrix();
        float fov = (float)Math.toRadians(45.0);
        float aspectRatio = (float)window.m_85445_() / (float)window.m_85446_();
        float zNear = 1000.0f;
        float zFar = 3000.0f;
        Matrix4f projectionMatrix = new Matrix4f().perspective(fov, aspectRatio, 1000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrix, (VertexSorting)VertexSorting.f_276633_);
        PoseStack mvStack = RenderSystem.getModelViewStack();
        mvStack.m_85836_();
        mvStack.m_166856_();
        mvStack.m_85837_(0.0, 0.0, -2000.0);
        RenderSystem.applyModelViewMatrix();
    }

    public static void endOverlayRender() {
        RenderSystem.restoreProjectionMatrix();
        RenderSystem.getModelViewStack().m_85849_();
    }

    private RenderUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

