/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.client.util;

import com.mojang.blaze3d.platform.InputConstants;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;

public class TrackedKeyBinding {
    private static final Map<KeyMapping, TrackedKeyBinding> bindings = new HashMap<KeyMapping, TrackedKeyBinding>();
    private static boolean resetForScreen = false;
    private final KeyMapping parent;
    private boolean changedThisTick;
    private boolean pressedThisTick;
    private boolean releasedThisTick;

    public static void resetValues(boolean clientScreenAssigned) {
        bindings.values().forEach(TrackedKeyBinding::reset);
        if (clientScreenAssigned) {
            bindings.values().stream().filter(TrackedKeyBinding::isDown).forEach(TrackedKeyBinding::markReleased);
            resetForScreen = true;
        } else {
            resetForScreen = false;
        }
    }

    private TrackedKeyBinding(KeyMapping parent) {
        this.parent = parent;
    }

    public static TrackedKeyBinding createAndRegister(String translationKey, InputConstants.Type type, int code, String category) {
        return TrackedKeyBinding.createAndRegister(translationKey, type, code, category, KeyMappingRegistry::register);
    }

    public static TrackedKeyBinding createAndRegister(String translationKey, InputConstants.Type type, int code, String category, Consumer<KeyMapping> register) {
        KeyMapping keyBinding = new KeyMapping(translationKey, type, code, category);
        register.accept(keyBinding);
        return TrackedKeyBinding.wrap(keyBinding);
    }

    public static TrackedKeyBinding wrap(KeyMapping binding) {
        TrackedKeyBinding trackingBinding = new TrackedKeyBinding(binding);
        bindings.put(binding, trackingBinding);
        return trackingBinding;
    }

    public static void onKeyPressSet(KeyMapping binding, boolean pressed) {
        TrackedKeyBinding trackedBinding = bindings.get(binding);
        if (trackedBinding == null) {
            return;
        }
        if (pressed) {
            trackedBinding.markPressed();
        } else {
            trackedBinding.markReleased();
        }
    }

    public boolean isDown() {
        return this.parent.m_90857_();
    }

    private void markPressed() {
        this.changedThisTick = true;
        if (!this.releasedThisTick) {
            this.pressedThisTick = true;
        }
    }

    private void markReleased() {
        this.changedThisTick = true;
        this.pressedThisTick = false;
        this.releasedThisTick = true;
    }

    private void reset() {
        this.releasedThisTick = false;
        this.pressedThisTick = false;
        this.changedThisTick = false;
    }

    public KeyMapping getParent() {
        return this.parent;
    }

    public boolean isChangedThisTick() {
        return this.changedThisTick;
    }

    public boolean isPressedThisTick() {
        return this.pressedThisTick;
    }

    public boolean isReleasedThisTick() {
        return this.releasedThisTick;
    }
}

