/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.advancements;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.JRegistries;
import net.arna.jcraft.api.spec.SpecType;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObtainedSpecTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public static final ResourceLocation ID = JCraft.id("obtained_spec");

    public ResourceLocation m_7295_() {
        return ID;
    }

    protected TriggerInstance createInstance(JsonObject json, ContextAwarePredicate predicate, DeserializationContext deserializationContext) {
        ResourceLocation resourceLocation;
        SpecType type = null;
        if (json.has("spec") && (type = (SpecType)JRegistries.SPEC_TYPE_REGISTRY.get(resourceLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"spec")))) == null) {
            throw new JsonSyntaxException("Unknown spec '" + String.valueOf(resourceLocation) + "'");
        }
        return new TriggerInstance(predicate, type);
    }

    public void trigger(ServerPlayer player, @NotNull SpecType type) {
        this.m_66234_(player, trigger -> trigger.matches(type));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        @Nullable
        private final SpecType type;

        public TriggerInstance(ContextAwarePredicate player, @Nullable SpecType type) {
            super(ID, player);
            this.type = type;
        }

        public static TriggerInstance obtainedSpec(@Nullable SpecType type) {
            return new TriggerInstance(ContextAwarePredicate.f_285567_, type);
        }

        public static TriggerInstance obtainedSpec() {
            return TriggerInstance.obtainedSpec(null);
        }

        public boolean matches(@Nullable SpecType type) {
            return this.type == null || this.type == type;
        }

        @NotNull
        public JsonObject m_7683_(@NotNull SerializationContext context) {
            JsonObject jsonObject = super.m_7683_(context);
            if (this.type != null) {
                jsonObject.addProperty("spec", JRegistries.SPEC_TYPE_REGISTRY.getId((Object)this.type).toString());
            }
            return jsonObject;
        }
    }
}

