/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.advancements;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.JRegistries;
import net.arna.jcraft.api.stand.StandType;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObtainedStandTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public static final ResourceLocation ID = JCraft.id("obtained_stand");

    public ResourceLocation m_7295_() {
        return ID;
    }

    protected TriggerInstance createInstance(JsonObject json, ContextAwarePredicate predicate, DeserializationContext deserializationContext) {
        ResourceLocation resourceLocation;
        StandType type = null;
        if (json.has("stand") && (type = (StandType)JRegistries.STAND_TYPE_REGISTRY.get(resourceLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"stand")))) == null) {
            throw new JsonSyntaxException("Unknown stand '" + String.valueOf(resourceLocation) + "'");
        }
        return new TriggerInstance(predicate, type);
    }

    public void trigger(ServerPlayer player, @NotNull StandType type) {
        this.m_66234_(player, trigger -> trigger.matches(type));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        @Nullable
        private final StandType type;

        public TriggerInstance(ContextAwarePredicate player, @Nullable StandType type) {
            super(ID, player);
            this.type = type;
        }

        public static TriggerInstance obtainedStand(@Nullable StandType type) {
            return new TriggerInstance(ContextAwarePredicate.f_285567_, type);
        }

        public static TriggerInstance obtainedStand() {
            return TriggerInstance.obtainedStand(null);
        }

        public boolean matches(@Nullable StandType type) {
            return this.type == null || this.type == type;
        }

        @NotNull
        public JsonObject m_7683_(@NotNull SerializationContext context) {
            JsonObject jsonObject = super.m_7683_(context);
            if (this.type != null) {
                jsonObject.addProperty("stand", JRegistries.STAND_TYPE_REGISTRY.getId((Object)this.type).toString());
            }
            return jsonObject;
        }
    }
}

