/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.ai;

import lombok.NonNull;
import net.arna.jcraft.common.ai.CombatInstantContext;
import net.minecraft.world.phys.Vec3;

public class AttackerBrainInfo {
    private final CombatInstantContext combatCtx;
    private final int aiLevel;
    private State state = State.IDLE;
    private int ticksSinceStateChange = 0;
    private int reactionTime = 0;
    private Vec3 awayPos = null;
    private int desiredStandOffTime = 0;
    private int desiredNoAttackTime = 0;

    public boolean desiresNoAttack() {
        return this.desiredNoAttackTime > 0;
    }

    public void setState(@NonNull State state) {
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        if (this.state != state) {
            this.ticksSinceStateChange = 0;
        }
        this.state = state;
    }

    public void tick() {
        ++this.ticksSinceStateChange;
        --this.desiredStandOffTime;
        --this.desiredNoAttackTime;
    }

    public AttackerBrainInfo(int aiLevel) {
        this.aiLevel = aiLevel;
        this.combatCtx = new CombatInstantContext();
    }

    public CombatInstantContext getCombatCtx() {
        return this.combatCtx;
    }

    public int getAiLevel() {
        return this.aiLevel;
    }

    public State getState() {
        return this.state;
    }

    public int getTicksSinceStateChange() {
        return this.ticksSinceStateChange;
    }

    public void setTicksSinceStateChange(int ticksSinceStateChange) {
        this.ticksSinceStateChange = ticksSinceStateChange;
    }

    public int getReactionTime() {
        return this.reactionTime;
    }

    public void setReactionTime(int reactionTime) {
        this.reactionTime = reactionTime;
    }

    public Vec3 getAwayPos() {
        return this.awayPos;
    }

    public void setAwayPos(Vec3 awayPos) {
        this.awayPos = awayPos;
    }

    public int getDesiredStandOffTime() {
        return this.desiredStandOffTime;
    }

    public void setDesiredStandOffTime(int desiredStandOffTime) {
        this.desiredStandOffTime = desiredStandOffTime;
    }

    public void setDesiredNoAttackTime(int desiredNoAttackTime) {
        this.desiredNoAttackTime = desiredNoAttackTime;
    }

    public static enum State {
        IDLE,
        APPROACH,
        PRESSURE,
        COMBOING,
        DISENGAGE,
        KEEPAWAY,
        DEFENSE,
        COMBOED;

    }
}

