/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.ai;

import lombok.NonNull;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.spec.JSpec;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class CombatEntityContext {
    @NonNull
    private final LivingEntity entity;
    @Nullable
    private StandEntity<?, ?> stand;
    @Nullable
    private AbstractMove<?, ?> standAttack;
    @Nullable
    private final JSpec<?, ?> spec;
    @Nullable
    private final AbstractMove<?, ?> specAttack;
    private final int moveStun;
    private final boolean blocking;
    @Nullable
    private final MobEffectInstance stun;

    public LivingEntity entity() {
        return this.entity;
    }

    public StandEntity<?, ?> stand() {
        return this.stand;
    }

    public AbstractMove<?, ?> standAttack() {
        return this.standAttack;
    }

    public JSpec<?, ?> spec() {
        return this.spec;
    }

    public AbstractMove<?, ?> specAttack() {
        return this.specAttack;
    }

    public int moveStun() {
        return this.moveStun;
    }

    public boolean blocking() {
        return this.blocking;
    }

    public MobEffectInstance stun() {
        return this.stun;
    }

    public CombatEntityContext(@NonNull LivingEntity entity, @Nullable StandEntity<?, ?> stand, @Nullable AbstractMove<?, ?> standAttack, @Nullable JSpec<?, ?> spec, @Nullable AbstractMove<?, ?> specAttack, int moveStun, boolean blocking, @Nullable MobEffectInstance stun) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        this.entity = entity;
        this.stand = stand;
        this.standAttack = standAttack;
        this.spec = spec;
        this.specAttack = specAttack;
        this.moveStun = moveStun;
        this.blocking = blocking;
        this.stun = stun;
    }

    public void reassignStand(@Nullable StandEntity<?, ?> stand) {
        this.stand = stand;
        this.standAttack = stand == null ? null : stand.getCurrentMove();
    }

    public int disadvantage() {
        if (this.stun == null) {
            return this.moveStun;
        }
        return Math.max(this.moveStun, this.stun.m_19557_());
    }

    public static CombatEntityContext from(LivingEntity entity) {
        StandEntity<?, ?> stand = JUtils.getStand(entity);
        JSpec<?, ?> spec = JUtils.getSpec(entity);
        return new CombatEntityContext(entity, stand, stand == null ? null : stand.getCurrentMove(), spec, spec == null ? null : spec.getCurrentMove(), Math.max(stand == null ? 0 : stand.getMoveStun(), spec == null ? 0 : spec.getMoveStun()), stand != null && stand.blocking, entity.m_21124_((MobEffect)JStatusRegistry.DAZED.get()));
    }

    public boolean noWindupsPassed() {
        if (this.standAttack != null && this.standAttack.hasWindupPassed(this.stand)) {
            return false;
        }
        return this.specAttack == null || !this.specAttack.hasWindupPassed(this.spec);
    }
}

