/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.ai;

import lombok.NonNull;
import net.arna.jcraft.common.ai.CombatEntityContext;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.world.entity.LivingEntity;

public class CombatInstantContext {
    private CombatEntityContext attackerCtx;
    private CombatEntityContext targetCtx;
    private double distanceBetween;

    public void update(@NonNull LivingEntity attacker, @NonNull LivingEntity target) {
        if (attacker == null) {
            throw new NullPointerException("attacker is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        this.attackerCtx = CombatEntityContext.from(attacker);
        this.targetCtx = CombatEntityContext.from(target);
        this.distanceBetween = Math.sqrt(JUtils.min(JUtils.nullSafeDistanceSqr(attacker, target), JUtils.nullSafeDistanceSqr(attacker, this.targetCtx.stand()), JUtils.nullSafeDistanceSqr(this.attackerCtx.stand(), target), JUtils.nullSafeDistanceSqr(this.attackerCtx.stand(), this.targetCtx.stand())));
    }

    public CombatEntityContext getAttackerCtx() {
        return this.attackerCtx;
    }

    public CombatEntityContext getTargetCtx() {
        return this.targetCtx;
    }

    public double getDistanceBetween() {
        return this.distanceBetween;
    }
}

