/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.ai;

import net.arna.jcraft.api.attack.enums.StunType;
import net.arna.jcraft.common.ai.AttackerBrainInfo;
import net.arna.jcraft.common.ai.CombatInstantContext;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public interface IJAttackerBrain {
    public static final int MIN_LEVEL = 0;
    public static final int BEGINNER_LEVEL = 3;
    public static final int INTERMEDIATE_LEVEL = 10;
    public static final int COMPETITIVE_LEVEL = 15;
    public static final int MAX_LEVEL = 20;

    public static void planDefense(AttackerBrainInfo info) {
        info.tick();
        if (info.getCombatCtx().getAttackerCtx().blocking()) {
            info.setState(AttackerBrainInfo.State.DEFENSE);
            return;
        }
        MobEffectInstance stun = info.getCombatCtx().getAttackerCtx().stun();
        if (stun == null) {
            return;
        }
        if (stun.m_19564_() == StunType.BLOCK.ordinal()) {
            info.setState(AttackerBrainInfo.State.DEFENSE);
        } else {
            info.setState(AttackerBrainInfo.State.COMBOED);
        }
    }

    public static void pacing(AttackerBrainInfo info, CombatInstantContext combatCtx) {
        int aiLevel = info.getAiLevel();
        RandomSource random = combatCtx.getAttackerCtx().entity().m_217043_();
        if (aiLevel < 10) {
            float chanceToDoNothing = (float)(10 - aiLevel) * 0.11f;
            if (random.m_188501_() > chanceToDoNothing) {
                info.setDesiredNoAttackTime(random.m_188503_(20 - aiLevel));
            }
        }
    }

    @Nullable
    public static CombatInstantContext target(Mob mob, AttackerBrainInfo info) {
        LivingEntity target = mob.m_5448_();
        if (target == null) {
            target = mob.m_271686_();
        }
        if (target == null) {
            return null;
        }
        CombatInstantContext combatCtx = info.getCombatCtx();
        combatCtx.update((LivingEntity)mob, target);
        return combatCtx;
    }

    public static int reactionTimeFor(@Range(from=0L, to=20L) int aiLevel, RandomSource random) {
        int reactionTime = 10;
        reactionTime -= aiLevel / 5;
        if (aiLevel < 20) {
            reactionTime += Math.round(random.m_188501_() * 2.0f * (float)(20 - aiLevel) / 20.0f);
        }
        return reactionTime;
    }
}

