/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.ai.brain;

import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.ai.AttackerBrainInfo;
import net.arna.jcraft.common.ai.CombatInstantContext;
import net.arna.jcraft.common.ai.IJAttackerBrain;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public interface StandAttackerBrain
extends IJAttackerBrain {
    public static StandEntity<?, ?> handleDesiredSummoning(Mob mob, AttackerBrainInfo info, CombatInstantContext combatCtx) {
        boolean isStandOnDesired;
        boolean bl = isStandOnDesired = info.getDesiredStandOffTime() <= 0;
        if (info.getState() == AttackerBrainInfo.State.DEFENSE) {
            isStandOnDesired = true;
        }
        StandEntity<?, ?> stand = JUtils.getStand((LivingEntity)mob);
        if (isStandOnDesired) {
            if (stand == null) {
                stand = JCraft.summon((LivingEntity)mob);
            }
            combatCtx.getAttackerCtx().reassignStand(stand);
        } else {
            if (stand != null) {
                stand.desummon();
            }
            combatCtx.getAttackerCtx().reassignStand(stand);
            if (stand == null || stand.m_213877_()) {
                return null;
            }
        }
        return stand;
    }

    public static void tick(Mob mob, AttackerBrainInfo info) {
        CombatInstantContext combatCtx = IJAttackerBrain.target(mob, info);
        if (combatCtx == null) {
            return;
        }
        int aiLevel = info.getAiLevel();
        info.setReactionTime(IJAttackerBrain.reactionTimeFor(aiLevel, mob.m_217043_()));
        StandEntity<?, ?> stand = StandAttackerBrain.handleDesiredSummoning(mob, info, combatCtx);
        StandAttackerBrain.plan(aiLevel, info, combatCtx);
        stand = StandAttackerBrain.handleDesiredSummoning(mob, info, combatCtx);
        if (stand != null) {
            stand.executePlan(aiLevel, info, combatCtx);
        }
    }

    public static void plan(int aiLevel, AttackerBrainInfo info, CombatInstantContext combatCtx) {
        IJAttackerBrain.planDefense(info);
        IJAttackerBrain.pacing(info, combatCtx);
        StandEntity<?, ?> stand = combatCtx.getAttackerCtx().stand();
        if (stand == null) {
            return;
        }
        stand.plan(aiLevel, info, combatCtx);
    }
}

