/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.argumenttype;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.minecraft.network.chat.Component;

public class AttackArgumentType
implements ArgumentType<MoveClass> {
    private static final SimpleCommandExceptionType NOT_FOUND = new SimpleCommandExceptionType((Message)Component.m_237113_((String)"That attack type does not exist"));
    private static final Map<String, MoveClass> suggestions = (Map)Arrays.stream(MoveClass.values()).collect(ImmutableMap.toImmutableMap(type -> type.name().toLowerCase(Locale.ROOT), type -> type));
    private final Collection<String> examples = ImmutableList.of((Object)"RANDOM", (Object)"LIGHT", (Object)"BARRAGE", (Object)"UTILITY");

    public MoveClass parse(StringReader reader) throws CommandSyntaxException {
        String name = reader.readUnquotedString();
        if ("RANDOM".equals(name.toUpperCase(Locale.ROOT))) {
            return MoveClass.randomMoveType();
        }
        try {
            return MoveClass.valueOf(name.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw NOT_FOUND.createWithContext((ImmutableStringReader)reader);
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String input = builder.getRemainingLowerCase().replaceAll("_", "");
        suggestions.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(input)).map(Map.Entry::getValue).map(Enum::name).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        if ("random".startsWith(input)) {
            builder.suggest("RANDOM");
        }
        return builder.buildFuture();
    }

    public Collection<String> getExamples() {
        return this.examples;
    }

    private AttackArgumentType() {
    }

    public static AttackArgumentType attack() {
        return new AttackArgumentType();
    }
}

