/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.argumenttype;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.arna.jcraft.api.JRegistries;
import net.arna.jcraft.api.registry.JSpecTypeRegistry;
import net.arna.jcraft.api.spec.SpecType;
import net.minecraft.network.chat.Component;

public class SpecArgumentType
implements ArgumentType<SpecType> {
    private static final SimpleCommandExceptionType NOT_FOUND = new SimpleCommandExceptionType((Message)Component.m_237113_((String)"That stand was not found"));
    private final Collection<String> examples = ImmutableList.of((Object)"jcraft:brawler", (Object)"anubis");

    public SpecType parse(StringReader reader) throws CommandSyntaxException {
        SpecType specType = JRegistries.parseRegistryEntry(JRegistries.SPEC_TYPE_REGISTRY, reader, s -> true);
        if (specType == null) {
            throw NOT_FOUND.createWithContext((ImmutableStringReader)reader);
        }
        return specType;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return JRegistries.listSuggestions(JRegistries.SPEC_TYPE_REGISTRY, builder, spec -> spec != JSpecTypeRegistry.NONE.get());
    }

    private SpecArgumentType() {
    }

    public static SpecArgumentType spec() {
        return new SpecArgumentType();
    }

    public Collection<String> getExamples() {
        return this.examples;
    }
}

