/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.argumenttype;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.arna.jcraft.api.JRegistries;
import net.arna.jcraft.api.stand.StandType;
import net.minecraft.network.chat.Component;

public class StandArgumentType
implements ArgumentType<StandType> {
    public static final SimpleCommandExceptionType NOT_FOUND = new SimpleCommandExceptionType((Message)Component.m_237113_((String)"That stand was not found"));
    private final Collection<String> examples = ImmutableList.of((Object)"jcraft:made_in_heaven", (Object)"magicians_red", (Object)"jcraft:d4c");

    public StandType parse(StringReader reader) throws CommandSyntaxException {
        StandType type = JRegistries.parseRegistryEntry(JRegistries.STAND_TYPE_REGISTRY, reader, t -> t.getData().isObtainable());
        if (type == null) {
            throw NOT_FOUND.createWithContext((ImmutableStringReader)reader);
        }
        return type;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return JRegistries.listSuggestions(JRegistries.STAND_TYPE_REGISTRY, builder, type -> type.getData().isObtainable());
    }

    private StandArgumentType() {
    }

    public static StandArgumentType stand() {
        return new StandArgumentType();
    }

    public Collection<String> getExamples() {
        return this.examples;
    }
}

